/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.nbt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.aufdemrand.denizen.utilities.nbt.MapOfEnchantments;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.minecraft.server.v1_10_R1.Entity;
import net.minecraft.server.v1_10_R1.EntityLiving;
import net.minecraft.server.v1_10_R1.NBTBase;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.NBTTagList;
import net.minecraft.server.v1_10_R1.NBTTagString;
import org.bukkit.craftbukkit.v1_10_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_10_R1.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomNBT {
    public static MapOfEnchantments getEnchantments(ItemStack item) {
        return new MapOfEnchantments(item);
    }

    public static boolean hasCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return false;
        }
        net.minecraft.server.v1_10_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            return false;
        }
        key = CoreUtilities.toLowerCase(key);
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String getCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_10_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        NBTTagCompound tag = cis.getTag();
        key = CoreUtilities.toLowerCase(key);
        String finalKey = null;
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            finalKey = string;
            break;
        }
        if (finalKey == null) {
            return null;
        }
        Iterator<String> subkeys = CoreUtilities.split(finalKey, '.').iterator();
        if (subkeys.hasNext()) {
            while (true) {
                String subkey = subkeys.next();
                NBTBase base = tag.get(subkey);
                if (!subkeys.hasNext()) {
                    if (base instanceof NBTTagString) {
                        return ((NBTTagString)base).c_();
                    }
                    return base.toString();
                }
                if (!(base instanceof NBTTagCompound)) break;
                tag = (NBTTagCompound)base;
            }
            return null;
        }
        return null;
    }

    public static ItemStack removeCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_10_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        NBTTagCompound tag = cis.getTag();
        key = CoreUtilities.toLowerCase(key);
        String finalKey = null;
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            finalKey = string;
            break;
        }
        if (finalKey == null) {
            return null;
        }
        Iterator<String> subkeys = CoreUtilities.split(finalKey, '.').iterator();
        if (subkeys.hasNext()) {
            while (true) {
                String subkey = subkeys.next();
                if (!subkeys.hasNext()) {
                    tag.remove(subkey);
                    cis = CustomNBT.unregisterNBT(cis, key);
                    break;
                }
                if (tag.get(subkey).getTypeId() != tag.getTypeId()) break;
                tag = tag.getCompound(subkey);
            }
        }
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_10_R1.ItemStack)cis);
    }

    public static List<String> listNBT(ItemStack item, String filter) {
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_10_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        NBTTagCompound tag = cis.getTag();
        return CustomNBT.recursiveSearch(tag, "", filter);
    }

    private static List<String> recursiveSearch(NBTTagCompound compound, String base, String filter) {
        Set keys = compound.c();
        ArrayList<String> finalKeys = new ArrayList<String>();
        filter = CoreUtilities.toLowerCase(filter);
        for (String key : keys) {
            String full = base + key;
            if (CoreUtilities.toLowerCase(full).startsWith(filter)) {
                finalKeys.add(full);
            }
            if (compound.get(key).getTypeId() != compound.getTypeId()) continue;
            finalKeys.addAll(CustomNBT.recursiveSearch(compound.getCompound(key), full + ".", filter));
        }
        return finalKeys;
    }

    public static ItemStack addCustomNBT(ItemStack item, String key, String value) {
        net.minecraft.server.v1_10_R1.ItemStack cis;
        block10: {
            if (item == null) {
                return null;
            }
            cis = CraftItemStack.asNMSCopy((ItemStack)item);
            if (!cis.hasTag()) {
                cis.setTag(new NBTTagCompound());
            }
            NBTTagCompound tag = cis.getTag();
            List<String> existingKeys = CustomNBT.listNBT(item, "");
            String existing = "";
            String lowerKey = CoreUtilities.toLowerCase(key);
            for (String existingKey : existingKeys) {
                String exKeyLower = CoreUtilities.toLowerCase(existingKey);
                if (lowerKey.equals(exKeyLower)) {
                    existing = existingKey;
                    break;
                }
                if (!lowerKey.startsWith(CoreUtilities.toLowerCase(existingKey)) || existingKey.length() <= existing.length() || !lowerKey.substring(existingKey.length(), existingKey.length() + 1).equals(".")) continue;
                existing = existingKey;
            }
            String finalKey = null;
            if (!existing.equals("")) {
                for (String subkey : CoreUtilities.split(existing, '.')) {
                    NBTBase base = tag.get(subkey);
                    if (base instanceof NBTTagCompound) {
                        tag = (NBTTagCompound)base;
                        continue;
                    }
                    finalKey = subkey;
                }
            }
            if (finalKey == null) {
                Iterator<String> subkeys = CoreUtilities.split(key.substring(existing.equals("") ? 0 : existing.length() + 1), '.').iterator();
                while (true) {
                    String subkey;
                    subkey = subkeys.next();
                    if (!subkeys.hasNext()) {
                        tag.setString(subkey, value);
                        cis = CustomNBT.registerNBT(cis, key);
                        break block10;
                    }
                    tag.set(subkey, (NBTBase)new NBTTagCompound());
                    tag = tag.getCompound(subkey);
                }
            }
            tag.setString(finalKey, value);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_10_R1.ItemStack)cis);
    }

    private static net.minecraft.server.v1_10_R1.ItemStack registerNBT(net.minecraft.server.v1_10_R1.ItemStack item, String key) {
        NBTTagList list;
        NBTTagCompound tag;
        if (item == null) {
            return null;
        }
        if (!item.hasTag()) {
            item.setTag(new NBTTagCompound());
        }
        if ((tag = item.getTag()).hasKeyOfType("Denizen-Registered-Keys", (int)(list = new NBTTagList()).getTypeId())) {
            list = tag.getList("Denizen-Registered-Keys", (int)new NBTTagString().getTypeId());
        }
        list.add((NBTBase)new NBTTagString(key));
        tag.set("Denizen-Registered-Keys", (NBTBase)list);
        return item;
    }

    private static net.minecraft.server.v1_10_R1.ItemStack unregisterNBT(net.minecraft.server.v1_10_R1.ItemStack item, String key) {
        NBTTagList list;
        if (item == null) {
            return null;
        }
        if (!item.hasTag()) {
            return item;
        }
        NBTTagCompound tag = item.getTag();
        if (!tag.hasKeyOfType("Denizen-Registered-Keys", (int)(list = new NBTTagList()).getTypeId())) {
            return item;
        }
        list = tag.getList("Denizen-Registered-Keys", (int)new NBTTagString().getTypeId());
        String lowerKey = CoreUtilities.toLowerCase(key);
        for (int i = 0; i < list.size(); ++i) {
            if (!CoreUtilities.toLowerCase(list.getString(i)).equals(lowerKey)) continue;
            list.remove(i);
            break;
        }
        tag.set("Denizen-Registered-Keys", (NBTBase)list);
        return item;
    }

    public static List<String> getRegisteredNBT(ItemStack item) {
        NBTTagList list;
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_10_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            return null;
        }
        NBTTagCompound tag = cis.getTag();
        if (!tag.hasKeyOfType("Denizen-Registered-Keys", (int)(list = new NBTTagList()).getTypeId())) {
            return null;
        }
        list = tag.getList("Denizen-Registered-Keys", (int)new NBTTagString().getTypeId());
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(list.getString(i));
        }
        return ret;
    }

    public static LivingEntity addCustomNBT(LivingEntity entity, String key, String value) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        tag.setString(key, value);
        ((EntityLiving)nmsEntity).a(tag);
        return entity;
    }

    public static LivingEntity removeCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        tag.remove(key);
        ((EntityLiving)nmsEntity).a(tag);
        return entity;
    }

    public static boolean hasCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return false;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        return tag.hasKey(key);
    }

    public static String getCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        return tag.getString(key);
    }
}

