/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_10_R1.BlockPosition;
import net.minecraft.server.v1_10_R1.NBTBase;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.NBTTagList;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_10_R1.TileEntityBanner;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_10_R1.block.CraftBanner;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BannerUpdate {
    private static final Field tile_location;
    private static final Field tile_action;
    private static final Field tile_data;

    public static PacketPlayOutTileEntityData getTileEntityDataPacket(Location location, DyeColor base, List<Pattern> patterns) {
        PacketPlayOutTileEntityData packet = new PacketPlayOutTileEntityData();
        try {
            tile_location.set(packet, new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            tile_action.set(packet, 6);
            NBTTagCompound compound = new NBTTagCompound();
            ((CraftBanner)location.getBlock().getState()).getTileEntity().save(compound);
            NBTTagList nbtPatterns = new NBTTagList();
            for (Pattern pattern : patterns) {
                NBTTagCompound patternCompound = new NBTTagCompound();
                patternCompound.setInt("Color", (int)pattern.getColor().getDyeData());
                patternCompound.setString("Pattern", pattern.getPattern().getIdentifier());
                nbtPatterns.add((NBTBase)patternCompound);
            }
            TileEntityBanner.a((NBTTagCompound)compound, (int)base.getDyeData(), (NBTTagList)nbtPatterns);
            tile_data.set(packet, compound);
        }
        catch (IllegalAccessException e) {
            dB.echoError(e);
        }
        return packet;
    }

    public static void updateBanner(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        PacketPlayOutTileEntityData packet = BannerUpdate.getTileEntityDataPacket(location, base, patterns);
        PacketHelper.sendPacket(player, (Packet)packet);
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutTileEntityData.class);
        tile_location = fields.get("a");
        tile_action = fields.get("b");
        tile_data = fields.get("c");
    }
}

