/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets.intercept;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.events.player.ResourcePackStatusScriptEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.aufdemrand.denizen.utilities.packets.intercept.AbstractListenerPlayIn;
import net.aufdemrand.denizen.utilities.packets.intercept.DenizenNetworkManager;
import net.aufdemrand.denizencore.objects.Element;
import net.minecraft.server.v1_10_R1.EntityPlayer;
import net.minecraft.server.v1_10_R1.ItemStack;
import net.minecraft.server.v1_10_R1.NBTBase;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.NBTTagList;
import net.minecraft.server.v1_10_R1.NBTTagString;
import net.minecraft.server.v1_10_R1.NetworkManager;
import net.minecraft.server.v1_10_R1.Packet;
import net.minecraft.server.v1_10_R1.PacketPlayInResourcePackStatus;
import net.minecraft.server.v1_10_R1.PacketPlayInSetCreativeSlot;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class DenizenPacketListener
extends AbstractListenerPlayIn {
    private static final Field resource_pack_hash;
    private static final Field resource_pack_status;
    private static final Field nbttaglist_list;

    public DenizenPacketListener(NetworkManager networkManager, EntityPlayer entityPlayer) {
        super(networkManager, entityPlayer, entityPlayer.playerConnection);
    }

    public static void enable() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(), (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void a(PacketPlayInSetCreativeSlot packet) {
        NBTTagCompound tag;
        ItemStack itemStack = packet.getItemStack();
        if (itemStack != null && itemStack.hasTag() && !itemStack.getTag().isEmpty() && (tag = itemStack.getTag()).hasKey("Denizen Item Script")) {
            NBTTagCompound display = tag.getCompound("display");
            NBTTagList nbtLore = display.hasKey("Lore") ? (NBTTagList)display.get("Lore") : new NBTTagList();
            try {
                if (nbtLore.size() == 0) {
                    nbtLore.add((NBTBase)new NBTTagString(tag.getString("Denizen Item Script")));
                } else {
                    List list = (List)nbttaglist_list.get(nbtLore);
                    list.add(0, new NBTTagString(tag.getString("Denizen Item Script")));
                }
                display.set("Lore", (NBTBase)nbtLore);
            }
            catch (IllegalAccessException e) {
                dB.echoError(e);
            }
            tag.set("display", (NBTBase)display);
            tag.remove("Denizen Item Script");
            itemStack.setTag(tag);
        }
        super.a(packet);
    }

    public void a(PacketPlayInResourcePackStatus packet) {
        try {
            final String hash = (String)resource_pack_hash.get(packet);
            final PacketPlayInResourcePackStatus.EnumResourcePackStatus status = (PacketPlayInResourcePackStatus.EnumResourcePackStatus)resource_pack_status.get(packet);
            Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    ResourcePackStatusScriptEvent event = ResourcePackStatusScriptEvent.instance;
                    event.hash = new Element(hash);
                    event.status = new Element(status.name());
                    event.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)DenizenPacketListener.this.player.getBukkitEntity());
                    event.fire();
                }
            });
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        super.a(packet);
    }

    public void sendPacket(Packet packet) {
        super.sendPacket(packet);
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayInResourcePackStatus.class);
        resource_pack_hash = fields.get("a");
        resource_pack_status = fields.get("status");
        fields = PacketHelper.registerFields(NBTTagList.class);
        nbttaglist_list = fields.get("list");
    }

    public static class PlayerEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerJoin(PlayerJoinEvent event) {
            DenizenNetworkManager.setNetworkManager(event.getPlayer());
        }
    }
}

