/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.ItemDropListenerType;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemDropListenerInstance
extends AbstractListener
implements Listener {
    ItemDropListenerType.ItemDropType type = null;
    ItemStack item = null;
    Location location = null;
    Material block = null;
    EntityType mob = null;
    String dropper = null;
    String region = null;
    Integer radius = 5;
    Integer dropRate = 100;
    Integer quantity = 1;
    Integer qtyDropped = 0;

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public void onBuild(List<aH.Argument> args) {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onLoad() {
        this.type = ItemDropListenerType.ItemDropType.valueOf((String)this.get("type"));
        this.item = (ItemStack)this.get("item");
        this.location = (Location)this.get("location");
        this.block = (Material)this.get("block");
        this.mob = (EntityType)this.get("mob");
        this.dropper = (String)this.get("dropper");
        this.region = (String)this.get("region");
        this.radius = (Integer)this.get("radius");
        this.dropRate = (Integer)this.get("dropRate");
        this.quantity = (Integer)this.get("required");
        this.qtyDropped = (Integer)this.get("qtyDropped");
    }

    @Override
    public void onSave() {
        this.store("type", (Object)this.type);
        this.store("item", this.item);
        this.store("lcoation", this.location);
        this.store("block", this.block);
        this.store("mob", this.mob);
        this.store("dropper", this.dropper);
        this.store("region", this.region);
        this.store("radius", this.radius);
        this.store("dropRate", this.dropRate);
        this.store("required", this.quantity);
        this.store("qtyDropped", this.qtyDropped);
    }

    @Override
    public String report() {
        switch (this.type) {
            case BLOCKBREAK: {
                break;
            }
            case BLOCKPLACE: {
                break;
            }
            case MOBKILL: {
                break;
            }
        }
        return null;
    }

    @EventHandler
    public void mobKilled(EntityDeathEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.MOBKILL) {
            return;
        }
        dB.log("...checking kill");
        if (event.getEntity().getKiller() != this.player.getPlayerEntity()) {
            return;
        }
        dB.log("...killed by player");
        if (event.getEntity().getType() != this.mob) {
            return;
        }
        dB.log("...proper mob");
        if (this.location != null && this.location.distance(this.player.getPlayerEntity().getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.log("...within range");
        if (this.region != null) {
            // empty if block
        }
        dB.log("...within region (deprecated)");
        dB.log("...trying to drop item");
        if (CoreUtilities.getRandom().nextInt(101) < this.dropRate) {
            dB.log("...item should drop now");
            event.getEntity().getWorld().dropItem(event.getEntity().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.log("...item dropped");
            this.check();
        }
    }

    @EventHandler
    public void blockMined(BlockBreakEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.BLOCKBREAK) {
            return;
        }
        dB.log("...checking blockbreakevent");
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        dB.log("...mined by player");
        if (event.getBlock().getType() != this.block) {
            return;
        }
        dB.log("...proper block mined");
        if (this.location != null && this.location.distance(this.player.getPlayerEntity().getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.log("...within range");
        if (this.region != null) {
            // empty if block
        }
        dB.log("...within region(deprecated)");
        if (CoreUtilities.getRandom().nextInt(101) < this.dropRate) {
            event.getBlock().getWorld().dropItem(event.getBlock().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.log("...item dropped");
            this.check();
        }
    }

    @EventHandler
    public void blockPlaced(BlockPlaceEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.BLOCKPLACE) {
            return;
        }
        dB.log("...checking blockplaceevent");
        if (event.getPlayer() != this.player.getPlayerEntity()) {
            return;
        }
        dB.log("...placed by player");
        if (event.getBlock().getType() != this.block) {
            return;
        }
        dB.log("...proper block placed");
        if (this.location != null && this.location.distance(this.player.getPlayerEntity().getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.log("...within range");
        if (this.region != null) {
            // empty if block
        }
        dB.log("...within region(deprecated)");
        if (CoreUtilities.getRandom().nextInt(101) < this.dropRate) {
            event.getBlock().getWorld().dropItem(event.getBlock().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.log("...item dropped");
            this.check();
        }
    }

    private void check() {
        dB.log(this.qtyDropped + "/" + this.quantity + " dropped");
        if (this.quantity.equals(this.qtyDropped)) {
            this.finish();
        }
    }
}

