/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class KillListenerInstance
extends AbstractListener
implements Listener {
    KillType type = null;
    dList targets;
    dList names;
    int required = 1;
    int kills_so_far = 0;
    String region = null;
    dCuboid cuboid = null;

    @Override
    public String report() {
        return this.player.getName() + " currently has quest listener '" + this.id + "' active and must kill " + Arrays.toString(this.targets.toArray()) + " '" + this.type.name() + "'(s) named " + Arrays.toString(this.names.toArray()) + ". Current progress '" + this.kills_so_far + "/" + this.required + "'.";
    }

    @Override
    public void onBuild(List<aH.Argument> args) {
        for (aH.Argument arg : args) {
            if (arg.matchesEnum(KillType.values()) && this.type == null) {
                this.type = KillType.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (arg.matchesPrefix("qty, q") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                this.required = aH.getIntegerFrom(arg.getValue());
                continue;
            }
            if (arg.matchesPrefix("region, r")) {
                this.region = arg.getValue();
                continue;
            }
            if (arg.matchesPrefix("cuboid, c") && arg.matchesArgumentType(dCuboid.class)) {
                this.cuboid = arg.asType(dCuboid.class);
                continue;
            }
            if (arg.matchesPrefix("targets, target, t, name, names")) {
                this.targets = arg.asType(dList.class);
                continue;
            }
            if (!arg.matchesPrefix("mobnames, mn")) continue;
            this.names = arg.asType(dList.class);
        }
        if (this.targets == null) {
            this.targets = new dList("*");
        }
        if (this.names == null) {
            this.names = new dList("*");
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: NPC, ENTITY, PLAYER, GROUP");
            this.cancel();
        } else if (this.type == KillType.NPC && Depends.citizens == null) {
            dB.echoError("Invalid TYPE argument 'NPC': Citizens2 is not enabled.");
            this.cancel();
        }
    }

    @Override
    public void onLoad() {
        this.type = KillType.valueOf((String)this.get("Type"));
        this.targets = new dList((List)this.get("Targets"));
        this.names = new dList((List)this.get("Names"));
        this.required = (Integer)this.get("Quantity");
        this.kills_so_far = (Integer)this.get("Current Kills");
        this.region = (String)this.get("Region");
        this.cuboid = dCuboid.valueOf((String)this.get("Cuboid"));
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Targets", this.targets);
        this.store("Names", this.names);
        this.store("Quantity", this.required);
        this.store("Current Kills", this.kills_so_far);
        this.store("Region", this.region);
        if (this.cuboid != null) {
            this.store("Cuboid", this.cuboid.identify());
        }
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
        TagManager.registerTagEvents(this);
        dB.log(this.report());
    }

    @Override
    public void deconstructed() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
        TagManager.unregisterTagEvents(this);
    }

    @EventHandler
    public void listen(EntityDeathEvent event) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        if (event.getEntity().getKiller() != this.player.getPlayerEntity()) {
                            return;
                        }
                        if (this.region != null) {
                            // empty if block
                        }
                        if (this.cuboid != null && !this.cuboid.isInsideCuboid(this.player.getLocation())) {
                            return;
                        }
                        if (this.type != KillType.ENTITY) break block13;
                        dEntity ent = new dEntity((Entity)event.getEntity());
                        boolean count_it = false;
                        for (String target : this.targets) {
                            if (dEntity.valueOf(target) == null || ent.comparesTo(dEntity.valueOf(target)) != 1) continue;
                            count_it = true;
                        }
                        boolean right_name = false;
                        for (String name : this.names) {
                            if (!ChatColor.stripColor((String)ent.getName()).contains(name)) continue;
                            right_name = true;
                        }
                        if (!count_it && !this.targets.contains("*") || !right_name && !this.names.contains("*")) break block14;
                        ++this.kills_so_far;
                        dB.log(this.player.getName() + " killed a " + ent.identify() + ". Current progress '" + this.kills_so_far + "/" + this.required + "'.");
                        this.check();
                        break block14;
                    }
                    if (this.type != KillType.NPC) break block15;
                    if (!CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity())) {
                        return;
                    }
                    dNPC npc = dNPC.mirrorCitizensNPC(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()));
                    boolean count_it = false;
                    for (String target : this.targets) {
                        if (dNPC.valueOf(target) != null && dNPC.valueOf(target).getId() == npc.getId()) {
                            count_it = true;
                        }
                        if (!CoreUtilities.toLowerCase(npc.getName()).equals(CoreUtilities.toLowerCase(target).replace("n@", ""))) continue;
                        count_it = true;
                    }
                    if (!count_it && !this.targets.contains("*")) break block14;
                    ++this.kills_so_far;
                    dB.log(this.player.getName() + " killed " + npc.toString() + ". Current progress '" + this.kills_so_far + "/" + this.required + "'.");
                    this.check();
                    break block14;
                }
                if (this.type != KillType.PLAYER) break block16;
                if (event.getEntityType() != EntityType.PLAYER) {
                    return;
                }
                if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity())) {
                    return;
                }
                dPlayer player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)event.getEntity()));
                boolean count_it = false;
                for (String target : this.targets) {
                    if (dPlayer.valueOf(target) == null || !dPlayer.valueOf(target).getName().equalsIgnoreCase(player.getName())) continue;
                    count_it = true;
                }
                if (!count_it && !this.targets.contains("*")) break block14;
                ++this.kills_so_far;
                dB.log(player.getName() + " killed " + player.getName() + ". Current progress '" + this.kills_so_far + "/" + this.required + "'.");
                this.check();
                break block14;
            }
            if (this.type == KillType.GROUP && event.getEntityType() == EntityType.PLAYER) {
                for (String group : Depends.permissions.getPlayerGroups((Player)event.getEntity())) {
                    if (!this.targets.contains(group.toUpperCase())) continue;
                    ++this.kills_so_far;
                    dB.log(this.player.getName() + " killed " + ((Player)event.getEntity()).getName().toUpperCase() + " of group " + group + ".");
                    this.check();
                    break;
                }
            }
        }
    }

    public void check() {
        if (this.kills_so_far >= this.required) {
            this.finish();
        }
    }

    @TagManager.TagEvents
    public void listenTag(ReplaceableTagEvent event) {
        if (!event.matches("LISTENER")) {
            return;
        }
        if (!event.getType().equalsIgnoreCase(this.id)) {
            return;
        }
        if (event.getValue().equalsIgnoreCase("region")) {
            event.setReplaced(this.region);
        } else if (event.getValue().equalsIgnoreCase("required")) {
            event.setReplaced(String.valueOf(this.required));
        } else if (event.getValue().equalsIgnoreCase("currentkills")) {
            event.setReplaced(String.valueOf(this.kills_so_far));
        } else if (event.getValue().equalsIgnoreCase("targets")) {
            String targetList = "";
            for (String curTar : this.targets) {
                targetList = targetList + curTar + ", ";
                targetList = targetList.substring(0, targetList.length() - 1);
            }
            event.setReplaced(targetList);
        } else if (event.getValue().equalsIgnoreCase("mobnames")) {
            String namesList = "";
            for (String curNam : this.names) {
                namesList = namesList + curNam + ", ";
                namesList = namesList.substring(0, namesList.length() - 1);
            }
            event.setReplaced(namesList);
        }
    }

    public static enum KillType {
        NPC,
        PLAYER,
        GROUP,
        ENTITY;

    }
}

