/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemLore
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemLore getFrom(dObject _item) {
        if (!ItemLore.describes(_item)) {
            return null;
        }
        return new ItemLore((dItem)_item);
    }

    public boolean hasLore() {
        return this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta().hasLore();
    }

    private ItemLore(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("lore.escaped") && this.hasLore()) {
            return new Element(this.getPropertyString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("lore") && this.hasLore()) {
            ArrayList<String> loreList = new ArrayList<String>();
            for (String itemLore : this.item.getItemStack().getItemMeta().getLore()) {
                if (itemLore.startsWith("\u00a70id:") || itemLore.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                loreList.add(itemLore);
            }
            return new dList((List<String>)loreList).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_lore")) {
            return new Element(this.hasLore()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.hasLore()) {
            StringBuilder output = new StringBuilder();
            for (String itemLore : this.item.getItemStack().getItemMeta().getLore()) {
                if (itemLore.startsWith("\u00a70id:") || itemLore.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                output.append(EscapeTags.Escape(itemLore)).append("|");
            }
            return output.length() == 0 ? null : output.substring(0, output.length() - 1);
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "lore";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("lore")) {
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            dList lore = mechanism.getValue().asType(dList.class);
            if (this.item.isItemscript()) {
                lore.add(0, ItemScriptHelper.createItemScriptID(this.item.getScriptName()));
            }
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, EscapeTags.unEscape((String)lore.get(i)));
            }
            meta.setLore((List)lore);
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

