/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class HealCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("amount") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(dList.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                specified_targets = true;
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entities", Arrays.asList(arg.asType(dEntity.class)));
                specified_targets = true;
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new Element(-1));
        }
        if (!specified_targets) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() != null) {
                entities.add(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity());
            } else if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() != null) {
                entities.add(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found.");
            }
            scriptEntry.addObject("entities", entities);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        if (entities == null) {
            return;
        }
        Element amountelement = scriptEntry.getElement("amount");
        dB.report(scriptEntry, this.getName(), amountelement.debug() + aH.debugObj("entities", entities));
        if (amountelement.asDouble() == -1.0) {
            for (dEntity entity : entities) {
                if (!entity.isLivingEntity()) continue;
                entity.getLivingEntity().setHealth(entity.getLivingEntity().getMaxHealth());
            }
        } else {
            double amount = amountelement.asDouble();
            for (dEntity entity : entities) {
                if (entity.getLivingEntity().getHealth() + amount < entity.getLivingEntity().getMaxHealth()) {
                    entity.getLivingEntity().setHealth(entity.getLivingEntity().getHealth() + amount);
                    continue;
                }
                entity.getLivingEntity().setHealth(entity.getLivingEntity().getMaxHealth());
            }
        }
    }
}

