/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;

public class SpawnCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("spread") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("spread", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("persistent") && arg.matches("persistent")) {
                scriptEntry.addObject("persistent", "");
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getLocation() : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getLocation() : null);
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dEntity target = (dEntity)scriptEntry.getObject("target");
        Element spread = scriptEntry.getElement("spread");
        boolean persistent = scriptEntry.hasObject("persistent");
        dB.report(scriptEntry, this.getName(), aH.debugObj("entities", entities.toString()) + location.debug() + (spread != null ? spread.debug() : "") + (target != null ? target.debug() : "") + (persistent ? aH.debugObj("persistent", "true") : ""));
        dList entityList = new dList();
        for (dEntity entity : entities) {
            Location loc = location.clone();
            if (spread != null) {
                loc.add((double)(CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt()), 0.0, (double)(CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt()));
            }
            entity.spawnAt(loc);
            entityList.add(entity.toString());
            if (persistent && entity.isLivingEntity()) {
                entity.getLivingEntity().setRemoveWhenFarAway(false);
            }
            if (target == null || !target.isLivingEntity()) continue;
            entity.target(target.getLivingEntity());
        }
        scriptEntry.addObject("spawned_entities", entityList);
    }
}

