/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.ParticleHelper;
import net.aufdemrand.denizen.nms.interfaces.Effect;
import net.aufdemrand.denizen.nms.interfaces.Particle;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class PlayEffectCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ParticleHelper particleHelper = NMSHandler.getInstance().getParticleHelper();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dList.class).filter(dLocation.class));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
                Element typeId;
                if (particleHelper.hasParticle(arg.getValue())) {
                    scriptEntry.addObject("particleeffect", particleHelper.getEffect(arg.getValue()));
                    continue;
                }
                if (arg.matches("random")) {
                    if (CoreUtilities.getRandom().nextDouble() < 0.5) {
                        List<Particle> visible = particleHelper.getVisibleParticles();
                        scriptEntry.addObject("particleeffect", visible.get(CoreUtilities.getRandom().nextInt(visible.size())));
                        continue;
                    }
                    List<Effect> visual = particleHelper.getVisualEffects();
                    scriptEntry.addObject("effect", visual.get(CoreUtilities.getRandom().nextInt(visual.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    String[] split = shrunk.split(",");
                    Element typeId2 = new Element(split[0]);
                    if (typeId2.isInt() && typeId2.asInt() > 0 && Material.getMaterial((int)typeId2.asInt()) != null) {
                        scriptEntry.addObject("iconcrack", typeId2);
                    } else {
                        dB.echoError("Invalid iconcrack_[id]. Must be a valid Material ID, besides 0.");
                    }
                    Element dataId = new Element(split.length <= 1 ? "0" : split[1]);
                    scriptEntry.addObject("iconcrack_data", dataId);
                    scriptEntry.addObject("iconcrack_type", new Element("iconcrack"));
                    continue;
                }
                if (arg.startsWith("blockcrack_")) {
                    String shrunk = arg.getValue().substring("blockcrack_".length());
                    typeId = new Element(shrunk);
                    if (typeId.isInt() && typeId.asInt() > 0 && Material.getMaterial((int)typeId.asInt()) != null) {
                        scriptEntry.addObject("iconcrack", typeId);
                    } else {
                        dB.echoError("Invalid blockcrack_[id]. Must be a valid Material ID, besides 0.");
                    }
                    scriptEntry.addObject("iconcrack_type", new Element("blockcrack"));
                    continue;
                }
                if (arg.startsWith("blockdust_")) {
                    String shrunk = arg.getValue().substring("blockdust_".length());
                    typeId = new Element(shrunk);
                    if (typeId.isInt() && typeId.asInt() > 0 && Material.getMaterial((int)typeId.asInt()) != null) {
                        scriptEntry.addObject("iconcrack", typeId);
                    } else {
                        dB.echoError("Invalid blockdust_[id]. Must be a valid Material ID, besides 0.");
                    }
                    scriptEntry.addObject("iconcrack_type", new Element("blockdust"));
                    continue;
                }
                if (!particleHelper.hasEffect(arg.getValue())) continue;
                scriptEntry.addObject("effect", particleHelper.getEffect(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer) && arg.matchesPrefix("qty", "q", "quantity")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new dLocation(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(dPlayer.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() && ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isSpawned() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getLocation()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().isOnline() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getLocation()) : null);
        scriptEntry.defaultObject("data", new Element(0));
        scriptEntry.defaultObject("radius", new Element(15));
        scriptEntry.defaultObject("qty", new Element(1));
        scriptEntry.defaultObject("offset", new dLocation(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List locations = (List)scriptEntry.getObject("location");
        List targets = (List)scriptEntry.getObject("targets");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        Particle particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        Element iconcrack = scriptEntry.getElement("iconcrack");
        Element iconcrack_data = scriptEntry.getElement("iconcrack_data");
        Element iconcrack_type = scriptEntry.getElement("iconcrack_type");
        Element radius = scriptEntry.getElement("radius");
        Element data = scriptEntry.getElement("data");
        Element qty = scriptEntry.getElement("qty");
        dLocation offset = (dLocation)scriptEntry.getdObject("offset");
        dB.report(scriptEntry, this.getName(), (effect != null ? aH.debugObj("effect", effect.getName()) : (particleEffect != null ? aH.debugObj("special effect", particleEffect.getName()) : iconcrack_type.debug() + iconcrack.debug() + (iconcrack_data != null ? iconcrack_data.debug() : ""))) + aH.debugObj("locations", locations.toString()) + (targets != null ? aH.debugObj("targets", targets.toString()) : "") + radius.debug() + data.debug() + qty.debug() + offset.debug());
        for (dLocation location : locations) {
            MaterialData materialData;
            ArrayList<Player> players;
            float osZ;
            float osY;
            location.add(0.0, 1.0, 0.0);
            if (effect != null) {
                for (int n = 0; n < qty.asInt(); ++n) {
                    if (targets != null) {
                        for (dPlayer player : targets) {
                            if (!player.isValid() || !player.isOnline()) continue;
                            effect.playFor(player.getPlayerEntity(), location, data.asInt());
                        }
                        continue;
                    }
                    effect.play(location, data.asInt(), radius.asInt());
                }
                continue;
            }
            if (particleEffect != null) {
                float osX = (float)offset.getX();
                osY = (float)offset.getY();
                osZ = (float)offset.getZ();
                players = new ArrayList<Player>();
                if (targets == null) {
                    float rad = radius.asFloat();
                    for (Player player : location.getWorld().getPlayers()) {
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (dPlayer dPlayer2 : targets) {
                        if (!dPlayer2.isValid() || !dPlayer2.isOnline()) continue;
                        players.add(dPlayer2.getPlayerEntity());
                    }
                }
                for (Player player : players) {
                    particleEffect.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat());
                }
                continue;
            }
            float osX = (float)offset.getX();
            osY = (float)offset.getY();
            osZ = (float)offset.getZ();
            players = new ArrayList();
            if (targets == null) {
                float rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (dPlayer dPlayer3 : targets) {
                    if (!dPlayer3.isValid() || !dPlayer3.isOnline()) continue;
                    players.add(dPlayer3.getPlayerEntity());
                }
            }
            if (iconcrack_type.asString().equalsIgnoreCase("iconcrack")) {
                ItemStack itemStack = new ItemStack(iconcrack.asInt(), iconcrack_data.asInt());
                Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("ITEM_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), itemStack);
                }
                continue;
            }
            if (iconcrack_type.asString().equalsIgnoreCase("blockcrack")) {
                materialData = new MaterialData(iconcrack.asInt(), (byte)iconcrack_data.asInt());
                Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("BLOCK_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
                }
                continue;
            }
            materialData = new MaterialData(iconcrack.asInt(), (byte)iconcrack_data.asInt());
            Particle particle = NMSHandler.getInstance().getParticleHelper().getParticle("BLOCK_DUST");
            for (Player player : players) {
                particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
            }
        }
    }
}

