/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.ListTag;
import net.aufdemrand.denizen.nms.util.jnbt.StringTag;
import net.aufdemrand.denizen.nms.util.jnbt.Tag;
import net.aufdemrand.denizen.utilities.nbt.MapOfEnchantments;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class CustomNBT {
    public static MapOfEnchantments getEnchantments(ItemStack item) {
        return new MapOfEnchantments(item);
    }

    public static boolean hasCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return false;
        }
        key = CoreUtilities.toLowerCase(key);
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String getCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        key = CoreUtilities.toLowerCase(key);
        String finalKey = null;
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            finalKey = string;
            break;
        }
        if (finalKey == null) {
            return null;
        }
        Iterator<String> subkeys = CoreUtilities.split(finalKey, '.').iterator();
        if (subkeys.hasNext()) {
            while (true) {
                String subkey = subkeys.next();
                Tag base = (Tag)compoundTag.getValue().get(subkey);
                if (!subkeys.hasNext()) {
                    if (base instanceof StringTag) {
                        return ((StringTag)base).getValue();
                    }
                    return base.toString();
                }
                if (!(base instanceof CompoundTag)) break;
                compoundTag = (CompoundTag)base;
            }
            return null;
        }
        return null;
    }

    public static ItemStack removeCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        key = CoreUtilities.toLowerCase(key);
        String finalKey = null;
        List<String> keys = CustomNBT.listNBT(item, "");
        for (String string : keys) {
            if (!CoreUtilities.toLowerCase(string).equals(key)) continue;
            finalKey = string;
            break;
        }
        if (finalKey == null) {
            return null;
        }
        Iterator<String> subkeys = CoreUtilities.split(finalKey, '.').iterator();
        if (subkeys.hasNext()) {
            while (true) {
                String subkey = subkeys.next();
                if (!subkeys.hasNext()) {
                    compoundTag = compoundTag.createBuilder().remove(subkey).build();
                    item = CustomNBT.unregisterNBT(NMSHandler.getInstance().getItemHelper().setNbtData(item, compoundTag), key);
                    break;
                }
                if (!(compoundTag.getValue().get(subkey) instanceof CompoundTag)) break;
                compoundTag = (CompoundTag)compoundTag.getValue().get(subkey);
            }
        }
        return item;
    }

    public static List<String> listNBT(ItemStack item, String filter) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        return CustomNBT.recursiveSearch(compoundTag, "", filter);
    }

    private static List<String> recursiveSearch(CompoundTag compound, String base, String filter) {
        Object value = compound.getValue();
        Set keys = compound.getValue().keySet();
        ArrayList<String> finalKeys = new ArrayList<String>();
        filter = CoreUtilities.toLowerCase(filter);
        for (String key : keys) {
            String full = base + key;
            if (CoreUtilities.toLowerCase(full).startsWith(filter)) {
                finalKeys.add(full);
            }
            if (!(value.get(key) instanceof CompoundTag)) continue;
            finalKeys.addAll(CustomNBT.recursiveSearch((CompoundTag)value.get(key), full + ".", filter));
        }
        return finalKeys;
    }

    public static ItemStack addCustomNBT(ItemStack item, String key, String value) {
        CompoundTag compoundTag;
        block9: {
            if (item == null) {
                return null;
            }
            compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
            List<String> existingKeys = CustomNBT.listNBT(item, "");
            String existing = "";
            String lowerKey = CoreUtilities.toLowerCase(key);
            for (String existingKey : existingKeys) {
                String exKeyLower = CoreUtilities.toLowerCase(existingKey);
                if (lowerKey.equals(exKeyLower)) {
                    existing = existingKey;
                    break;
                }
                if (!lowerKey.startsWith(CoreUtilities.toLowerCase(existingKey)) || existingKey.length() <= existing.length() || !lowerKey.substring(existingKey.length(), existingKey.length() + 1).equals(".")) continue;
                existing = existingKey;
            }
            String finalKey = null;
            if (!existing.equals("")) {
                for (String subkey : CoreUtilities.split(existing, '.')) {
                    Tag base = (Tag)compoundTag.getValue().get(subkey);
                    if (base instanceof CompoundTag) {
                        compoundTag = (CompoundTag)base;
                        continue;
                    }
                    finalKey = subkey;
                }
            }
            if (finalKey == null) {
                Iterator<String> subkeys = CoreUtilities.split(key.substring(existing.equals("") ? 0 : existing.length() + 1), '.').iterator();
                while (true) {
                    String subkey;
                    subkey = subkeys.next();
                    if (!subkeys.hasNext()) {
                        compoundTag = compoundTag.createBuilder().putString(subkey, value).build();
                        item = CustomNBT.registerNBT(item, key);
                        break block9;
                    }
                    compoundTag = compoundTag.createBuilder().put(subkey, NMSHandler.getInstance().createCompoundTag(new HashMap<String, Tag>())).build();
                    compoundTag = (CompoundTag)compoundTag.getValue().get(subkey);
                }
            }
            compoundTag = compoundTag.createBuilder().putString(finalKey, value).build();
        }
        return NMSHandler.getInstance().getItemHelper().setNbtData(item, compoundTag);
    }

    private static ItemStack registerNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        List<Tag> list = compoundTag.getList("Denizen-Registered-Keys");
        list.add(new StringTag(key));
        compoundTag = compoundTag.createBuilder().put("Denizen-Registered-Keys", new ListTag(StringTag.class, list)).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(item, compoundTag);
    }

    private static ItemStack unregisterNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        ListTag list = compoundTag.getListTag("Denizen-Registered-Keys");
        if (list.getValue().isEmpty()) {
            return item;
        }
        Object value = list.getValue();
        String lowerKey = CoreUtilities.toLowerCase(key);
        for (int i = 0; i < list.getValue().size(); ++i) {
            if (!CoreUtilities.toLowerCase(list.getString(i)).equals(lowerKey)) continue;
            value.remove(i);
            break;
        }
        list.setValue((List<Tag>)value);
        compoundTag = compoundTag.createBuilder().put("Denizen-Registered-Keys", list).build();
        return NMSHandler.getInstance().getItemHelper().setNbtData(item, compoundTag);
    }

    public static List<String> getRegisteredNBT(ItemStack item) {
        if (item == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getItemHelper().getNbtData(item);
        ListTag list = compoundTag.getListTag("Denizen-Registered-Keys");
        if (list.getValue().isEmpty()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.getValue().size(); ++i) {
            ret.add(list.getString(i));
        }
        return ret;
    }

    public static Entity addCustomNBT(Entity entity, String key, String value) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        compoundTag = compoundTag.createBuilder().putString(key, value).build();
        NMSHandler.getInstance().getEntityHelper().setNbtData(entity, compoundTag);
        return entity;
    }

    public static Entity removeCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        compoundTag = compoundTag.createBuilder().remove(key).build();
        NMSHandler.getInstance().getEntityHelper().setNbtData(entity, compoundTag);
        return entity;
    }

    public static boolean hasCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return false;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        return compoundTag.getValue().containsKey(key);
    }

    public static String getCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.getInstance().getEntityHelper().getNbtData(entity);
        return compoundTag.getString(key);
    }
}

