/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CommandExecuter {
    private static final Pattern definition_pattern = Pattern.compile("%(.+?)%");

    public static List<String> parseDefs(List<String> args, ScriptEntry scriptEntry) {
        ArrayList<String> newArgs = new ArrayList<String>(args.size());
        for (String arg : args) {
            if (arg.indexOf(37) != -1) {
                Matcher m = definition_pattern.matcher(arg);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String def = m.group(1);
                    boolean dynamic = false;
                    if (def.startsWith("|")) {
                        def = def.substring(1, def.length() - 1);
                        dynamic = true;
                    }
                    String defval = scriptEntry.getResidingQueue().getDefinition(def);
                    String definition = dynamic ? scriptEntry.getResidingQueue().getDefinition(def) : TagManager.escapeOutput(scriptEntry.getResidingQueue().getDefinition(def));
                    if (defval == null) {
                        dB.echoError("Unknown definition %" + m.group(1) + "%.");
                        definition = "null";
                    }
                    dB.echoDebug((Debuggable)scriptEntry, "Filled definition %" + m.group(1) + "% with '" + definition + "'.");
                    m.appendReplacement(sb, Matcher.quoteReplacement(definition));
                }
                m.appendTail(sb);
                arg = sb.toString();
            }
            newArgs.add(arg);
        }
        return newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ScriptEntry scriptEntry) {
        AbstractCommand command;
        StringBuffer sb;
        Matcher m;
        StringBuilder output = new StringBuilder();
        output.append(scriptEntry.getCommandName());
        if (scriptEntry.getOriginalArguments() == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Original Arguments null for " + scriptEntry.getCommandName());
        } else {
            for (String arg : scriptEntry.getOriginalArguments()) {
                output.append(" \"").append(arg).append("\"");
            }
        }
        dB.echoDebug((Debuggable)scriptEntry, "Queue '" + scriptEntry.getResidingQueue().id + "' Executing: " + output.toString());
        if (scriptEntry.getCommandName().indexOf(37) != -1) {
            m = definition_pattern.matcher(scriptEntry.getCommandName());
            sb = new StringBuffer();
            while (m.find()) {
                String definition = scriptEntry.getResidingQueue().getDefinition(m.group(1));
                if (definition == null) {
                    dB.echoError("Unknown definition %" + m.group(1) + "%.");
                    definition = "null";
                }
                dB.echoDebug((Debuggable)scriptEntry, "Filled definition %" + m.group(1) + "% with '" + definition + "'.");
                m.appendReplacement(sb, Matcher.quoteReplacement(definition));
            }
            m.appendTail(sb);
            scriptEntry.setCommandName(sb.toString());
        }
        if ((command = scriptEntry.getCommand()) == null) {
            command = DenizenCore.getCommandRegistry().get(scriptEntry.getCommandName());
        }
        if (command == null) {
            dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
            dB.echoError(scriptEntry.getResidingQueue(), scriptEntry.getCommandName() + " is an invalid dCommand! Are you sure it loaded?");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            return false;
        }
        DenizenCore.getImplementation().handleCommandSpecialCases(scriptEntry);
        DenizenCore.getImplementation().debugCommandHeader(scriptEntry);
        boolean keepGoing = true;
        String saveName = null;
        try {
            if (command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                throw new InvalidArgumentsException("");
            }
            if (scriptEntry.has_tags) {
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), DenizenCore.getImplementation().getTagContextFor(scriptEntry, true)));
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            int nested_depth = 0;
            int argn = 0;
            for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
                ++argn;
                if (arg.getValue().equals("{")) {
                    ++nested_depth;
                }
                if (arg.getValue().equals("}")) {
                    --nested_depth;
                }
                if (nested_depth > 0) {
                    newArgs.add(arg.raw_value);
                    continue;
                }
                if (arg.raw_value.indexOf(37) != -1) {
                    m = definition_pattern.matcher(arg.raw_value);
                    sb = new StringBuffer();
                    while (m.find()) {
                        String def = m.group(1);
                        boolean dynamic = false;
                        if (def.startsWith("|")) {
                            def = def.substring(1, def.length() - 1);
                            dynamic = true;
                        }
                        String defval = scriptEntry.getResidingQueue().getDefinition(def);
                        String definition = dynamic ? scriptEntry.getResidingQueue().getDefinition(def) : TagManager.escapeOutput(scriptEntry.getResidingQueue().getDefinition(def));
                        if (defval == null) {
                            dB.echoError(scriptEntry.getResidingQueue(), "Unknown definition %" + m.group(1) + "%.");
                            dB.log("(Attempted: " + scriptEntry.toString() + ")");
                            definition = "null";
                        }
                        dB.echoDebug((Debuggable)scriptEntry, "Filled definition %" + m.group(1) + "% with '" + definition + "'.");
                        m.appendReplacement(sb, Matcher.quoteReplacement(definition));
                    }
                    m.appendTail(sb);
                    arg = aH.Argument.valueOf(sb.toString());
                    scriptEntry.modifiedArguments().set(argn - 1, sb.toString());
                }
                if (DenizenCore.getImplementation().handleCustomArgs(scriptEntry, arg, false)) continue;
                if (arg.matchesPrefix("save")) {
                    saveName = TagManager.tag(arg.getValue(), DenizenCore.getImplementation().getTagContext(scriptEntry));
                    dB.echoDebug((Debuggable)scriptEntry, "...remembering this script entry as '" + saveName + "'!");
                    continue;
                }
                if (!command.shouldPreParse()) continue;
                newArgs.add(arg.raw_value);
            }
            scriptEntry.setArguments(newArgs);
            scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), DenizenCore.getImplementation().getTagContextFor(scriptEntry, false)));
            command.parseArgs(scriptEntry);
        }
        catch (InvalidArgumentsException e) {
            keepGoing = false;
            dB.echoError(scriptEntry.getResidingQueue(), "Woah! Invalid arguments were specified!");
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                dB.log("+> MESSAGE follows: '" + e.getMessage() + "'");
            }
            dB.log("Usage: " + command.getUsageHint());
            dB.log("(Attempted: " + scriptEntry.toString() + ")");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            scriptEntry.setFinished(true);
        }
        catch (Exception e) {
            keepGoing = false;
            dB.echoError(scriptEntry.getResidingQueue(), "Woah! An exception has been called with this command!");
            dB.echoError(scriptEntry.getResidingQueue(), e);
            dB.log("(Attempted: " + scriptEntry.toString() + ")");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            scriptEntry.setFinished(true);
        }
        finally {
            if (keepGoing) {
                try {
                    command.execute(scriptEntry);
                    if (saveName != null) {
                        scriptEntry.getResidingQueue().holdScriptEntry(saveName, scriptEntry);
                    }
                }
                catch (Exception e) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Woah!! An exception has been called with this command!");
                    dB.echoError(scriptEntry.getResidingQueue(), e);
                    dB.log("(Attempted: " + scriptEntry.toString() + ")");
                    dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
                    scriptEntry.setFinished(true);
                }
            }
        }
        return true;
    }
}

