/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.scripts.commands.CommandExecuter;
import net.aufdemrand.denizencore.scripts.commands.core.Comparable;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class IfCommand
extends BracedCommand {
    @Override
    public void onEnable() {
        this.setBraced();
        this.setParseArgs(false);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean in_subcommand = false;
        boolean in_elsecommand = false;
        ArrayList<String> subcommand = new ArrayList<String>();
        ArrayList<String> elsecommand = new ArrayList<String>();
        ArrayList<String> comparisons = new ArrayList<String>();
        boolean has_brace = false;
        for (String arg : scriptEntry.getOriginalArguments()) {
            if (!arg.equalsIgnoreCase("{")) continue;
            if (dB.verbose) {
                dB.log("Has_brace = true");
            }
            has_brace = true;
            break;
        }
        if (has_brace) {
            scriptEntry.addObject("braces", IfCommand.getBracedCommands(scriptEntry));
        }
        for (String arg : scriptEntry.modifiedArguments()) {
            if (arg.equalsIgnoreCase("{")) break;
            if (!has_brace && !in_elsecommand && DenizenCore.getCommandRegistry().get(arg.toUpperCase()) != null) {
                in_subcommand = true;
                subcommand.add(arg);
                continue;
            }
            if (!has_brace && in_subcommand && arg.equalsIgnoreCase("else")) {
                in_elsecommand = true;
                in_subcommand = false;
                continue;
            }
            if (!has_brace && in_subcommand) {
                subcommand.add(arg);
                continue;
            }
            if (!has_brace && in_elsecommand) {
                elsecommand.add(arg);
                continue;
            }
            comparisons.add(arg);
        }
        if (!has_brace && in_elsecommand) {
            scriptEntry.addObject("elsecommand", elsecommand);
        }
        if (!has_brace && (in_subcommand || in_elsecommand)) {
            scriptEntry.addObject("subcommand", subcommand);
        }
        scriptEntry.addObject("comparisons", comparisons);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        boolean first_set;
        List subcommand = (List)scriptEntry.getObject("subcommand");
        List elsecommand = (List)scriptEntry.getObject("elsecommand");
        List comparisons = (List)scriptEntry.getObject("comparisons");
        List braces = (List)scriptEntry.getObject("braces");
        dB.report(scriptEntry, this.getName(), aH.debugObj("use_braces", braces != null));
        if (dB.verbose) {
            dB.log("comparisons=" + comparisons + ", sc:" + subcommand + ", ec:" + elsecommand);
        }
        if ((first_set = new ArgComparer().compare(comparisons, scriptEntry)) && subcommand != null && subcommand.size() > 0) {
            this.executeCommandList(subcommand, scriptEntry);
        }
        if (!first_set && elsecommand != null && elsecommand.size() > 0) {
            this.executeCommandList(elsecommand, scriptEntry);
        }
        if (braces != null) {
            if (first_set) {
                if (dB.verbose) {
                    dB.log("Running the first set");
                }
                List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)braces.get((int)0)).value;
                for (int i = 0; i < bracedCommandsList.size(); ++i) {
                    bracedCommandsList.get(i).setInstant(true);
                    bracedCommandsList.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
                }
                scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
            } else {
                for (int z = 1; z < braces.size(); ++z) {
                    BracedCommand.BracedData braceSet = (BracedCommand.BracedData)braces.get(z);
                    if (dB.verbose) {
                        dB.log("Trying: " + braceSet.key);
                    }
                    List<String> key = braceSet.args;
                    boolean should_fire = false;
                    if (key.size() > 0 && key.get(0).equalsIgnoreCase("else")) {
                        key.remove(0);
                    }
                    if (key.size() > 0 && key.get(0).equalsIgnoreCase("if")) {
                        key.remove(0);
                    } else {
                        should_fire = true;
                    }
                    if (!should_fire && new ArgComparer().compare(CommandExecuter.parseDefs(key, scriptEntry), scriptEntry)) {
                        should_fire = true;
                    }
                    if (!should_fire) continue;
                    List<ScriptEntry> bracedCommandsList = braceSet.value;
                    for (int i = 0; i < bracedCommandsList.size(); ++i) {
                        bracedCommandsList.get(i).setInstant(true);
                        bracedCommandsList.get(i).addObject("reqId", scriptEntry.getObject("reqId"));
                    }
                    scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
                    break;
                }
            }
        }
    }

    public void executeCommandList(List<String> subcommand, ScriptEntry scriptEntry) {
        try {
            String cmd = subcommand.get(0);
            subcommand.remove(0);
            ScriptEntry entry = new ScriptEntry(cmd, subcommand.toArray(new String[subcommand.size()]), scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
            entry.entryData = scriptEntry.entryData.clone();
            entry.setInstant(true);
            entry.addObject("reqId", scriptEntry.getObject("reqId"));
            scriptEntry.getResidingQueue().injectEntry(entry, 0);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    static class ArgComparer {
        List<String> argstemp = null;
        String[] argstemp_parsed = null;

        ArgComparer() {
        }

        public String tagme(int arg, ScriptEntry scriptEntry) {
            String parsed;
            if (this.argstemp_parsed[arg] != null) {
                return this.argstemp_parsed[arg];
            }
            this.argstemp_parsed[arg] = parsed = TagManager.tag(this.argstemp.get(arg), DenizenCore.getImplementation().getTagContextFor(scriptEntry, false));
            return parsed;
        }

        public boolean compare(List<String> args, ScriptEntry scriptEntry) {
            int x;
            String arg;
            int i;
            this.argstemp = args;
            this.argstemp_parsed = new String[args.size()];
            if (dB.verbose) {
                dB.log("Comparing " + args);
            }
            if (args.size() == 0) {
                if (dB.verbose) {
                    dB.log("Args.size == 0, return false");
                }
                return false;
            }
            if (args.size() == 1) {
                String arg2 = this.tagme(0, scriptEntry);
                boolean negative = false;
                if (arg2.startsWith("!")) {
                    arg2 = arg2.substring(1);
                    negative = true;
                }
                if (dB.verbose) {
                    dB.log("Returning comparison: " + args.get(0));
                }
                if (negative) {
                    return !arg2.equalsIgnoreCase("true");
                }
                return arg2.equalsIgnoreCase("true");
            }
            for (i = 0; i < args.size(); ++i) {
                arg = args.get(i);
                if (arg.equalsIgnoreCase("(")) {
                    ArrayList<String> subargs = new ArrayList<String>();
                    int count = 0;
                    boolean found = false;
                    for (x = i + 1; x < args.size(); ++x) {
                        String xarg = args.get(x);
                        if (xarg.equalsIgnoreCase("(")) {
                            ++count;
                            subargs.add("(");
                            continue;
                        }
                        if (xarg.equalsIgnoreCase(")")) {
                            if (--count == -1) {
                                boolean cfound = new ArgComparer().compare(subargs, scriptEntry);
                                for (int c = 0; c < x - i + 1; ++c) {
                                    args.remove(i);
                                }
                                args.add(i, cfound ? "true" : "false");
                                found = true;
                                continue;
                            }
                            subargs.add(")");
                            continue;
                        }
                        subargs.add(xarg);
                    }
                    if (found) continue;
                    if (dB.verbose) {
                        dB.log("Returning false: strange ()");
                    }
                    return false;
                }
                if (!arg.equalsIgnoreCase(")")) continue;
                if (dB.verbose) {
                    dB.log("Returning false: strange ()");
                }
                return false;
            }
            if (args.size() == 1) {
                if (dB.verbose) {
                    dB.log("Returning comparison: " + args.get(0));
                }
                return args.get(0).equalsIgnoreCase("true");
            }
            for (i = 0; i < args.size(); ++i) {
                boolean comp;
                boolean before;
                int x2;
                ArrayList<String> beforeargs;
                arg = args.get(i);
                if (arg.equalsIgnoreCase("||")) {
                    beforeargs = new ArrayList<String>(i);
                    for (x2 = 0; x2 < i; ++x2) {
                        beforeargs.add(args.get(x2));
                    }
                    before = new ArgComparer().compare(beforeargs, scriptEntry);
                    if (before) {
                        if (dB.verbose) {
                            dB.log("Returning true because true || irrel");
                        }
                        return true;
                    }
                    ArrayList<String> afterargs = new ArrayList<String>(i);
                    for (x = i + 1; x < args.size(); ++x) {
                        afterargs.add(args.get(x));
                    }
                    comp = new ArgComparer().compare(afterargs, scriptEntry);
                    if (dB.verbose) {
                        dB.log("Returning comparison: " + comp);
                    }
                    return comp;
                }
                if (!arg.equalsIgnoreCase("&&")) continue;
                beforeargs = new ArrayList(i);
                for (x2 = 0; x2 < i; ++x2) {
                    beforeargs.add(args.get(x2));
                }
                before = new ArgComparer().compare(beforeargs, scriptEntry);
                if (!before) {
                    if (dB.verbose) {
                        dB.log("Returning false because false && irrel");
                    }
                    return false;
                }
                ArrayList<String> afterargs = new ArrayList<String>(i);
                for (x = i + 1; x < args.size(); ++x) {
                    afterargs.add(args.get(x));
                }
                comp = new ArgComparer().compare(afterargs, scriptEntry);
                if (dB.verbose) {
                    dB.log("Returning comparison: " + comp);
                }
                return comp;
            }
            if (args.size() == 1) {
                String arg3 = args.get(0);
                boolean negative = false;
                if (arg3.startsWith("!")) {
                    arg3 = arg3.substring(1);
                    negative = true;
                }
                if (dB.verbose) {
                    dB.log("Returning comparison: " + args.get(0));
                }
                if (negative) {
                    return !arg3.equalsIgnoreCase("true");
                }
                return arg3.equalsIgnoreCase("true");
            }
            if (args.size() == 2) {
                if (dB.verbose) {
                    dB.log("Returning false because two args only");
                }
                return false;
            }
            String arg4 = args.get(1);
            boolean negative = false;
            if (arg4.startsWith("!")) {
                arg4 = arg4.substring(1);
                negative = true;
            }
            if (arg4.equals("==") || arg4.equals("=")) {
                arg4 = "EQUALS";
            } else if (arg4.equals(">=")) {
                arg4 = "OR_MORE";
            } else if (arg4.equals("<=")) {
                arg4 = "OR_LESS";
            } else if (arg4.equals("<")) {
                arg4 = "LESS";
            } else if (arg4.equals(">")) {
                arg4 = "MORE";
            } else if (arg4.equals("||")) {
                arg4 = "OR";
            } else if (arg4.equals("&&")) {
                arg4 = "AND";
            }
            Comparable comparable = new Comparable();
            if (negative) {
                comparable.logic = Comparable.Logic.NEGATIVE;
            }
            try {
                comparable.operator = Comparable.Operator.valueOf(arg4.toUpperCase());
                comparable.setComparable(this.tagme(0, scriptEntry));
                comparable.setComparedto(this.tagme(2, scriptEntry));
                boolean outcome = comparable.determineOutcome();
                dB.echoDebug((Debuggable)scriptEntry, comparable.toString());
                return outcome;
            }
            catch (IllegalArgumentException ex) {
                dB.echoError(ex.getMessage());
                return false;
            }
        }
    }
}

