/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.tags.TagContext;

public class BukkitScriptEntryData
extends ScriptEntryData {
    private dPlayer player;
    private dNPC npc;

    public BukkitScriptEntryData(dPlayer player, dNPC npc) {
        this.player = player;
        this.npc = npc;
    }

    public dPlayer getPlayer() {
        return this.player;
    }

    public dNPC getNPC() {
        return this.npc;
    }

    public boolean hasNPC() {
        return this.npc != null;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public void setPlayer(dPlayer player) {
        this.player = player;
    }

    public void setNPC(dNPC npc) {
        this.npc = npc;
    }

    @Override
    public void transferDataFrom(ScriptEntryData scriptEntryData) {
        if (scriptEntryData == null) {
            return;
        }
        this.player = ((BukkitScriptEntryData)scriptEntryData).getPlayer();
        this.npc = ((BukkitScriptEntryData)scriptEntryData).getNPC();
        this.scriptEntry = scriptEntryData.scriptEntry;
    }

    @Override
    public TagContext getTagContext() {
        return new BukkitTagContext(this.player, this.npc, false, this.scriptEntry, this.scriptEntry != null ? this.scriptEntry.shouldDebug() : true, this.scriptEntry != null ? this.scriptEntry.getScript() : null);
    }

    @Override
    public String toString() {
        if (this.npc == null && this.player == null) {
            return "";
        }
        if (this.npc == null) {
            return "player=p@" + this.player.getName();
        }
        if (this.player == null) {
            return "npc=n@" + this.npc.getId();
        }
        return "player=p@" + this.player.getName() + "   npc=n@" + this.npc.getId();
    }
}

