/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EntityDeathScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDeathScriptEvent instance;
    public dEntity entity;
    public dObject damager;
    public Element message;
    public dInventory inventory;
    public Element cause;
    public dList drops;
    public Integer xp;
    public boolean changed_drops;
    public boolean keep_inv;
    public boolean keep_level;
    public EntityDeathEvent event;

    public EntityDeathScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String cmd = CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s));
        return cmd.equals("dies") || cmd.equals("death");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String target = CoreUtilities.getXthArg(0, lower);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityDies";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("drops ")) {
            lower = lower.substring(6);
            determination = determination.substring(6);
        }
        if (lower.startsWith("no_drops")) {
            this.drops.clear();
            this.changed_drops = true;
            if (lower.endsWith("_or_xp")) {
                this.xp = 0;
            }
        } else if (lower.equals("no_xp")) {
            this.xp = 0;
        } else if (lower.equals("keep_inv")) {
            this.keep_inv = true;
        } else if (lower.equals("keep_level")) {
            this.keep_level = true;
        } else if (aH.matchesInteger(determination)) {
            this.xp = aH.Argument.valueOf(lower).asElement().asInt();
        } else if (aH.Argument.valueOf(lower).matchesArgumentList(dItem.class)) {
            this.drops.clear();
            this.changed_drops = true;
            dList drops_list = dList.valueOf(determination);
            drops_list.filter(dItem.class);
            for (String drop : drops_list) {
                dItem item = dItem.valueOf(drop);
                if (item == null) continue;
                this.drops.add(item.identify());
            }
        } else if (this.event instanceof PlayerDeathEvent) {
            this.message = new Element(determination);
        } else {
            return super.applyDetermination(container, determination);
        }
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager;
        }
        if (name.equals("message") && this.message != null) {
            return this.message;
        }
        if (name.equals("inventory") && this.inventory != null) {
            return this.inventory;
        }
        if (name.equals("cause") && this.cause != null) {
            return this.cause;
        }
        if (name.equals("drops") && this.drops != null) {
            return this.drops;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        dEntity.rememberEntity((Entity)livingEntity);
        this.entity = new dEntity((Entity)livingEntity);
        dPlayer player = null;
        if (this.entity.isPlayer()) {
            player = this.entity.getDenizenPlayer();
        }
        this.damager = null;
        EntityDamageEvent lastDamage = this.entity.getBukkitEntity().getLastDamageCause();
        if (lastDamage != null && lastDamage instanceof EntityDamageByEntityEvent) {
            this.damager = new dEntity(((EntityDamageByEntityEvent)lastDamage).getDamager()).getDenizenObject();
        }
        this.message = null;
        this.inventory = null;
        PlayerDeathEvent subEvent = null;
        if (event instanceof PlayerDeathEvent) {
            subEvent = (PlayerDeathEvent)event;
            this.message = new Element(subEvent.getDeathMessage());
            if (player != null) {
                this.inventory = player.getInventory();
            }
            this.keep_inv = subEvent.getKeepInventory();
            this.keep_level = subEvent.getKeepLevel();
        }
        this.cause = null;
        if (event.getEntity().getLastDamageCause() != null) {
            this.cause = new Element(event.getEntity().getLastDamageCause().getCause().toString());
        }
        this.drops = new dList();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null) {
                this.drops.add("i@air");
                continue;
            }
            this.drops.add(new dItem(stack).identify());
        }
        this.changed_drops = false;
        this.xp = event.getDroppedExp();
        this.event = event;
        this.fire();
        event.setDroppedExp(this.xp.intValue());
        if (this.changed_drops) {
            event.getDrops().clear();
            for (String drop : this.drops) {
                dItem item = dItem.valueOf(drop);
                if (item == null) continue;
                event.getDrops().add(item.getItemStack());
            }
        }
        if (event instanceof PlayerDeathEvent) {
            ((PlayerDeathEvent)event).setKeepInventory(this.keep_inv);
            ((PlayerDeathEvent)event).setKeepLevel(this.keep_level);
        }
        if (this.message != null && subEvent != null) {
            subEvent.setDeathMessage(this.message.asString());
        }
        if (this.cancelled && subEvent != null) {
            subEvent.setDeathMessage(null);
        }
        dEntity.forgetEntity((Entity)livingEntity);
    }
}

