/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.speech;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.speech.DenizenSpeechContext;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagManager;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.VocalChord;
import net.citizensnpcs.npc.ai.speech.TalkableEntity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DenizenChat
implements VocalChord {
    public final String VOCAL_CHORD_NAME = "denizen_chat";

    public String getName() {
        return "denizen_chat";
    }

    public void talk(SpeechContext speechContext) {
        if (!(speechContext instanceof DenizenSpeechContext)) {
            return;
        }
        DenizenSpeechContext context = (DenizenSpeechContext)speechContext;
        Talkable talker = context.getTalker();
        if (talker == null) {
            return;
        }
        ScriptEntry entry = context.getScriptEntry();
        ScriptQueue queue = entry.getResidingQueue();
        String defTalker = null;
        if (queue.hasDefinition("talker")) {
            defTalker = queue.getDefinition("talker");
        }
        queue.addDefinition("talker", new dEntity(talker.getEntity()).identify());
        String defMessage = null;
        if (queue.hasDefinition("message")) {
            defMessage = queue.getDefinition("message");
        }
        queue.addDefinition("message", context.getMessage());
        if (!context.hasRecipients()) {
            String text = TagManager.tag(Settings.chatNoTargetFormat(), new BukkitTagContext(entry, false));
            this.talkToBystanders(talker, text, context);
        } else if (context.size() <= 1) {
            String text = TagManager.tag(Settings.chatToTargetFormat(), new BukkitTagContext(entry, false));
            Iterator i$ = context.iterator();
            while (i$.hasNext()) {
                Talkable entity = (Talkable)i$.next();
                entity.talkTo((SpeechContext)context, text, (VocalChord)this);
            }
            if (context.isBystandersEnabled()) {
                String defTarget = null;
                if (queue.hasDefinition("target")) {
                    defTarget = queue.getDefinition("target");
                }
                queue.addDefinition("target", new dEntity(((Talkable)context.iterator().next()).getEntity()).identify());
                String bystanderText = TagManager.tag(Settings.chatWithTargetToBystandersFormat(), new BukkitTagContext(entry, false));
                this.talkToBystanders(talker, bystanderText, context);
                if (defTarget != null) {
                    queue.addDefinition("target", defTarget);
                }
            }
        } else {
            String text = TagManager.tag(Settings.chatToTargetFormat(), new BukkitTagContext(entry, false));
            Iterator i$ = context.iterator();
            while (i$.hasNext()) {
                Talkable entity = (Talkable)i$.next();
                entity.talkTo((SpeechContext)context, text, (VocalChord)this);
            }
            if (context.isBystandersEnabled()) {
                String[] format = Settings.chatMultipleTargetsFormat().split("%target%");
                if (format.length <= 1) {
                    dB.echoError("Invalid 'Commands.Chat.Options.Multiple targets format' in config.yml! Must have at least 1 %target%");
                }
                StringBuilder parsed = new StringBuilder();
                Iterator iter = context.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i == format.length) {
                        parsed.append(format[i]);
                        break;
                    }
                    parsed.append(format[i]).append(new dEntity(((Talkable)iter.next()).getEntity()).getName());
                    ++i;
                }
                String targets = TagManager.tag(parsed.toString(), new BukkitTagContext(entry, false));
                String defTargets = null;
                if (queue.hasDefinition("targets")) {
                    defTargets = queue.getDefinition("targets");
                }
                queue.addDefinition("targets", targets);
                String bystanderText = TagManager.tag(Settings.chatWithTargetsToBystandersFormat(), new BukkitTagContext(entry, false));
                this.talkToBystanders(talker, bystanderText, context);
                if (defTargets != null) {
                    queue.addDefinition("targets", defTargets);
                }
            }
        }
        if (defMessage != null) {
            queue.addDefinition("message", defMessage);
        }
        if (defTalker != null) {
            queue.addDefinition("talker", defTalker);
        }
    }

    private void talkToBystanders(Talkable talkable, String text, DenizenSpeechContext context) {
        double range = context.getChatRange();
        List<Player> bystanderEntities = new ArrayList();
        if (range == 0.0) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                bystanderEntities.add(player);
            }
        } else {
            bystanderEntities = talkable.getEntity().getNearbyEntities(range, range, range);
        }
        for (Entity entity : bystanderEntities) {
            boolean shouldTalk = true;
            if (context.hasRecipients()) {
                Iterator i$ = context.iterator();
                while (i$.hasNext()) {
                    Talkable target = (Talkable)i$.next();
                    if (!target.getEntity().equals(entity)) continue;
                    shouldTalk = false;
                    break;
                }
            }
            if (!shouldTalk) continue;
            new TalkableEntity(entity).talkNear((SpeechContext)context, text, (VocalChord)this);
        }
    }
}

