/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.DyeColor;

public class dColor
implements dObject {
    static final Pattern rgbPattern = Pattern.compile("(\\d+)[,:](\\d+)[,:](\\d+)");
    private org.bukkit.Color color;
    String prefix = "color";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dColor valueOf(String string) {
        return dColor.valueOf(string, null);
    }

    @Fetchable(value="co")
    public static dColor valueOf(String string, TagContext context) {
        if ((string = string.toUpperCase().replace("CO@", "")).matches("RANDOM")) {
            return new dColor(CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256));
        }
        Matcher m = rgbPattern.matcher(string);
        if (m.matches()) {
            return new dColor(aH.getIntegerFrom(m.group(1)), aH.getIntegerFrom(m.group(2)), aH.getIntegerFrom(m.group(3)));
        }
        Field colorField = null;
        try {
            colorField = org.bukkit.Color.class.getField(string.toUpperCase());
        }
        catch (SecurityException e1) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Security exception getting color field!");
        }
        catch (NoSuchFieldException e1) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("No such color field!");
        }
        if (colorField != null) {
            return new dColor(colorField);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if ((arg = arg.toUpperCase().replace("CO@", "")).toUpperCase().matches("RANDOM")) {
            return true;
        }
        Matcher m = rgbPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        for (Field field : org.bukkit.Color.class.getFields()) {
            if (!arg.toUpperCase().matches(field.getName())) continue;
            return true;
        }
        return false;
    }

    public dColor(int red, int green, int blue) {
        this.color = org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public dColor(Field field) {
        try {
            this.color = (org.bukkit.Color)field.get(null);
        }
        catch (Exception e) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Exception trying to fetch color!");
        }
    }

    public dColor(org.bukkit.Color color) {
        this.color = color;
    }

    public dColor(DyeColor dyeColor) {
        this.color = dyeColor.getColor();
    }

    public org.bukkit.Color getColor() {
        return this.color;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Color";
    }

    @Override
    public String identify() {
        for (Field field : org.bukkit.Color.class.getFields()) {
            try {
                if (((org.bukkit.Color)field.get(null)).asRGB() != this.getColor().asRGB()) continue;
                return "co@" + field.getName();
            }
            catch (Exception e) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Exception trying to fetch color!");
            }
        }
        return "co@" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        dColor.registerTag("red", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).color.getRed()).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("green", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).color.getGreen()).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("blue", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).color.getBlue()).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("rgb", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                org.bukkit.Color color = ((dColor)object).color;
                return new Element(color.getRed() + "," + color.getGreen() + "," + color.getBlue()).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("hue", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).ToHSB()[0]).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("saturation", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).ToHSB()[1]).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("brightness", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dColor)object).ToHSB()[2]).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("hsv", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int[] HSV = ((dColor)object).ToHSB();
                return new Element(HSV[1] + "," + HSV[1] + "," + HSV[2]).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.identify().substring(3)).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("mix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag li@list.insert[...] must have a value.");
                    return null;
                }
                dColor mixed_with = dColor.valueOf(attribute.getContext(1));
                if (mixed_with != null) {
                    return new dColor(((dColor)object).color.mixColors(new org.bukkit.Color[]{mixed_with.getColor()})).getAttribute(attribute.fulfill(1));
                }
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("'" + attribute.getContext(1) + "' is not a valid color!");
                return null;
            }
        });
        dColor.registerTag("to_particle_offset", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                org.bukkit.Color valid = ((dColor)object).color;
                if (valid.asRGB() == 0) {
                    valid = org.bukkit.Color.fromRGB((int)1, (int)0, (int)0);
                }
                return new dLocation(null, (float)valid.getRed() / 255.0f, (float)valid.getGreen() / 255.0f, (float)valid.getBlue() / 255.0f).getAttribute(attribute.fulfill(1));
            }
        });
        dColor.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Color").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    int[] ToHSB() {
        float[] base = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        return new int[]{(int)(base[0] * 255.0f), (int)(base[1] * 255.0f), (int)(base[2] * 255.0f)};
    }
}

