/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.List;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class EntityHealth
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).isLivingEntity();
    }

    public static EntityHealth getFrom(dObject entity) {
        if (!EntityHealth.describes(entity)) {
            return null;
        }
        return new EntityHealth((dEntity)entity);
    }

    private EntityHealth(dEntity ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.entity.getLivingEntity().getHealth() + "/" + this.entity.getLivingEntity().getMaxHealth());
    }

    @Override
    public String getPropertyId() {
        return "health_data";
    }

    public static String getHealthFormatted(dEntity entity, Attribute attribute) {
        double maxHealth = entity.getLivingEntity().getMaxHealth();
        if (attribute.hasContext(2)) {
            maxHealth = attribute.getIntContext(2);
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.1) {
            return new Element("dying").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.4) {
            return new Element("seriously wounded").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.75) {
            return new Element("injured").getAttribute(attribute.fulfill(2));
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 1.0) {
            return new Element("scraped").getAttribute(attribute.fulfill(2));
        }
        return new Element("healthy").getAttribute(attribute.fulfill(2));
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("health.formatted")) {
            return EntityHealth.getHealthFormatted(this.entity, attribute);
        }
        if (attribute.startsWith("health.max")) {
            return new Element(this.entity.getLivingEntity().getMaxHealth()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            double maxHealth = this.entity.getLivingEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(this.entity.getLivingEntity().getHealth() / maxHealth * 100.0).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new Element(this.entity.getLivingEntity().getHealth()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            if (this.entity.isCitizensNPC()) {
                if (this.entity.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)this.entity.getDenizenNPC().getCitizen().getTrait(HealthTrait.class)).setMaxhealth(mechanism.getValue().asInt());
                } else {
                    dB.echoError("NPC doesn't have health trait!");
                }
            } else if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setMaxHealth(mechanism.getValue().asDouble());
            } else {
                dB.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health_data")) {
            if (this.entity.isLivingEntity()) {
                List<String> values = CoreUtilities.split(mechanism.getValue().asString(), '/');
                this.entity.getLivingEntity().setMaxHealth(Double.valueOf(values.get(1)).doubleValue());
                this.entity.getLivingEntity().setHealth(Double.valueOf(values.get(0)).doubleValue());
            } else {
                dB.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setHealth(mechanism.getValue().asDouble());
            } else {
                dB.echoError("Entity is not alive!");
            }
        }
    }
}

