/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.enums.EntityAttribute;
import net.aufdemrand.denizen.nms.util.EntityAttributeModifier;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class ItemAttackSpeed
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemAttackSpeed getFrom(dObject item) {
        if (!ItemAttackSpeed.describes(item)) {
            return null;
        }
        return new ItemAttackSpeed((dItem)item);
    }

    private ItemAttackSpeed(dItem item) {
        this.item = item;
    }

    @Override
    public String getPropertyString() {
        dList list = new dList();
        Map<EntityAttribute, List<EntityAttributeModifier>> modifiers = NMSHandler.getInstance().getItemHelper().getAttributeModifiers(this.item.getItemStack());
        if (modifiers.containsKey((Object)EntityAttribute.GENERIC_ATTACK_SPEED)) {
            for (EntityAttributeModifier modifier : modifiers.get((Object)EntityAttribute.GENERIC_ATTACK_SPEED)) {
                list.add(modifier.getUniqueId().toString() + "/" + modifier.getName() + "/" + modifier.getOperation().name() + "/" + new Element(modifier.getAmount()).identify());
            }
        }
        return list.isEmpty() ? null : list.identify();
    }

    @Override
    public String getPropertyId() {
        return "attack_speed";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("attack_speed")) {
            String string = this.getPropertyString();
            if (string == null) {
                return null;
            }
            return new Element(string).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("attack_speed")) {
            Map<EntityAttribute, List<EntityAttributeModifier>> map = NMSHandler.getInstance().getItemHelper().getAttributeModifiers(this.item.getItemStack());
            ArrayList<EntityAttributeModifier> modifiers = new ArrayList<EntityAttributeModifier>();
            dList value = mechanism.getValue().asType(dList.class);
            for (String string : value) {
                List<String> split = CoreUtilities.split(string, '/', 4);
                UUID uuid = UUID.fromString(split.get(0));
                String name = split.get(1);
                EntityAttributeModifier.Operation operation = EntityAttributeModifier.Operation.valueOf(split.get(2).toUpperCase());
                double amount = new Element(split.get(3)).asDouble();
                modifiers.add(new EntityAttributeModifier(uuid, name, operation, amount));
            }
            map.put(EntityAttribute.GENERIC_ATTACK_SPEED, modifiers);
            this.item.setItemStack(NMSHandler.getInstance().getItemHelper().setAttributeModifiers(this.item.getItemStack(), map));
        }
    }
}

