/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class ResetCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("finishes", "finished", "finish") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.FINISH);
                continue;
            }
            if (arg.matches("fails", "failed", "fail") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.FAIL);
                continue;
            }
            if (arg.matches("cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.PLAYER_COOLDOWN);
                continue;
            }
            if (arg.matches("global_cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.GLOBAL_COOLDOWN);
                continue;
            }
            if (arg.matches("saves") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.SAVES);
                continue;
            }
            if (arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.getObject("type").equals((Object)Type.GLOBAL_COOLDOWN)) {
            scriptEntry.defaultObject("players", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.getObject("type").equals((Object)Type.SAVES)) {
            throw new InvalidArgumentsException("Must specify a script!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Object player = scriptEntry.getdObject("players");
        dList players = player instanceof dPlayer ? new dList(player.identify()) : (dList)scriptEntry.getdObject("players");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        dScript script = (dScript)scriptEntry.getdObject("script");
        dB.report(scriptEntry, this.getName(), (players != null ? players.debug() : "") + aH.debugObj("type", (Object)type) + (script != null ? script.debug() : ""));
        if (type == Type.GLOBAL_COOLDOWN) {
            CooldownCommand.setCooldown(null, Duration.ZERO, script.getName(), true);
            return;
        }
        for (String object : players) {
            dPlayer resettable = dPlayer.valueOf(object);
            if (!resettable.isValid()) continue;
            switch (type) {
                case FAIL: {
                    FailCommand.resetFails(resettable.getName(), script.getName());
                    return;
                }
                case FINISH: {
                    FinishCommand.resetFinishes(resettable.getName(), script.getName());
                    return;
                }
                case PLAYER_COOLDOWN: {
                    CooldownCommand.setCooldown(resettable, Duration.ZERO, script.getName(), false);
                    return;
                }
                case SAVES: {
                    DenizenAPI.getCurrentInstance().getSaves().set("Players." + resettable.getSaveName(), null);
                }
            }
        }
    }

    private static enum Type {
        FINISH,
        FAIL,
        PLAYER_COOLDOWN,
        GLOBAL_COOLDOWN,
        SAVES;

    }
}

