/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class HurtCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("amount") && (arg.matchesPrimitive(aH.PrimitiveType.Double) || arg.matchesPrimitive(aH.PrimitiveType.Integer))) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source", "s") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("source", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(dList.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                specified_targets = true;
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entities", Arrays.asList(arg.asType(dEntity.class)));
                specified_targets = true;
                continue;
            }
            if (!scriptEntry.hasObject("cause") && arg.matchesEnum((Enum<?>[])EntityDamageEvent.DamageCause.values())) {
                scriptEntry.addObject("cause", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new Element(1.0));
        }
        if (!specified_targets) {
            ArrayList<dEntity> entities = new ArrayList<dEntity>();
            if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() != null) {
                entities.add(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity());
            } else if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() != null) {
                entities.add(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found.");
            }
            scriptEntry.addObject("entities", entities);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dEntity source = (dEntity)scriptEntry.getObject("source");
        Element amountElement = scriptEntry.getElement("amount");
        Element cause = scriptEntry.getElement("cause");
        dB.report(scriptEntry, this.getName(), amountElement.debug() + aH.debugList("entities", entities) + (cause == null ? "" : cause.debug()) + (source == null ? "" : source.debug()));
        double amount = amountElement.asDouble();
        for (dEntity entity : entities) {
            if (entity.getLivingEntity() == null) {
                dB.echoDebug((Debuggable)scriptEntry, entity + " is not a living entity!");
                continue;
            }
            if (cause == null) {
                if (source == null) {
                    entity.getLivingEntity().damage(amount);
                    continue;
                }
                entity.getLivingEntity().damage(amount, source.getBukkitEntity());
                continue;
            }
            EntityDamageEvent ede = source == null ? new EntityDamageEvent(entity.getBukkitEntity(), EntityDamageEvent.DamageCause.valueOf((String)cause.asString().toUpperCase()), amount) : new EntityDamageByEntityEvent(source.getBukkitEntity(), entity.getBukkitEntity(), EntityDamageEvent.DamageCause.valueOf((String)cause.asString().toUpperCase()), amount);
            Bukkit.getPluginManager().callEvent((Event)ede);
            if (ede.isCancelled()) continue;
            if (source == null) {
                entity.getLivingEntity().damage(ede.getFinalDamage());
                continue;
            }
            entity.getLivingEntity().damage(ede.getFinalDamage(), source.getBukkitEntity());
        }
    }
}

