/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.Set;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public class EntityScriptContainer
extends ScriptContainer {
    public EntityScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public dEntity getEntityFrom() {
        return this.getEntityFrom(null, null);
    }

    public dEntity getEntityFrom(dPlayer player, dNPC npc) {
        dEntity entity = null;
        try {
            if (!this.contains("ENTITY_TYPE")) {
                throw new Exception("Missing entity_type argument!");
            }
            String entityType = TagManager.tag(this.getString("ENTITY_TYPE", ""), new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new dScript(this)));
            entity = dEntity.valueOf(entityType);
            Set<StringHolder> strings = this.getConfigurationSection("").getKeys(false);
            for (StringHolder string : strings) {
                if (string.low.equals("entity_type") || string.low.equals("type")) continue;
                String value = TagManager.tag(this.getString(string.low, ""), new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new dScript(this)));
                entity.adjust(new Mechanism(new Element(string.low), new Element(value)));
            }
            if (entity == null || entity.isUnique()) {
                return null;
            }
            entity.setEntityScript(this.getName());
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this entity script!");
            dB.echoError(e);
            entity = null;
        }
        return entity;
    }
}

