/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.bukkit.ScriptReloadEvent;
import net.aufdemrand.denizen.events.player.ItemRecipeFormedScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerCraftsItemScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class ItemScriptHelper
implements Listener {
    public static final Map<String, ItemScriptContainer> item_scripts = new ConcurrentHashMap<String, ItemScriptContainer>(8, 0.9f, 1);
    public static final Map<String, ItemScriptContainer> item_scripts_by_hash_id = new HashMap<String, ItemScriptContainer>();
    public static final Map<ItemScriptContainer, List<String>> recipes_to_register = new HashMap<ItemScriptContainer, List<String>>();
    public static final Map<ItemScriptContainer, String> shapeless_to_register = new HashMap<ItemScriptContainer, String>();
    public static final Map<ItemScriptContainer, String> furnace_to_register = new HashMap<ItemScriptContainer, String>();
    public static String ItemScriptHashID = ChatColor.RED.toString() + ChatColor.BLUE + ChatColor.BLACK;

    public ItemScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static void removeDenizenRecipes() {
        ItemScriptContainer.specialrecipesMap.clear();
        ItemScriptContainer.shapelessRecipesMap.clear();
    }

    @EventHandler
    public void scriptReload(ScriptReloadEvent event) {
        ItemScriptContainer container;
        for (Map.Entry<ItemScriptContainer, List<String>> entry : recipes_to_register.entrySet()) {
            container = entry.getKey();
            List<String> recipeList = entry.getValue();
            for (int n = 0; n < recipeList.size(); ++n) {
                recipeList.set(n, TagManager.tag(recipeList.get(n), new BukkitTagContext(container.player, container.npc, false, null, dB.shouldDebug(container), new dScript(container))));
            }
            ArrayList<dItem> ingredients = new ArrayList<dItem>();
            boolean shouldRegister = true;
            block2: for (String recipeRow : recipeList) {
                String[] elements;
                for (String element : elements = recipeRow.split("\\|", 3)) {
                    dItem ingredient = dItem.valueOf(element.replaceAll("[iImM]@", ""));
                    if (ingredient == null) {
                        dB.echoError("Invalid dItem ingredient, recipe will not be registered for item script '" + container.getName() + "': " + element);
                        shouldRegister = false;
                        break block2;
                    }
                    ingredients.add(ingredient);
                }
            }
            if (!shouldRegister) continue;
            ItemScriptContainer.specialrecipesMap.put(container, ingredients);
        }
        for (Map.Entry<ItemScriptContainer, Object> entry : shapeless_to_register.entrySet()) {
            container = entry.getKey();
            String string = (String)entry.getValue();
            String list = TagManager.tag(string, new BukkitTagContext(container.player, container.npc, false, null, dB.shouldDebug(container), new dScript(container)));
            ArrayList<dItem> ingredients = new ArrayList<dItem>();
            boolean shouldRegister = true;
            for (String element : dList.valueOf(list)) {
                dItem ingredient = dItem.valueOf(element.replaceAll("[iImM]@", ""));
                if (ingredient == null) {
                    dB.echoError("Invalid dItem ingredient, shapeless recipe will not be registered for item script '" + container.getName() + "': " + element);
                    shouldRegister = false;
                    break;
                }
                ingredients.add(ingredient);
            }
            if (!shouldRegister) continue;
            ItemScriptContainer.shapelessRecipesMap.put(container, ingredients);
        }
        for (Map.Entry<ItemScriptContainer, Object> entry : furnace_to_register.entrySet()) {
            dItem furnace_item = dItem.valueOf((String)entry.getValue());
            if (furnace_item == null) {
                dB.echoError("Invalid item '" + (String)entry.getValue() + "'");
                continue;
            }
            FurnaceRecipe recipe = new FurnaceRecipe(entry.getKey().getItemFrom().getItemStack(), furnace_item.getMaterial().getMaterial(), (int)furnace_item.getItemStack().getDurability());
            Bukkit.getServer().addRecipe((Recipe)recipe);
        }
        recipes_to_register.clear();
        shapeless_to_register.clear();
        furnace_to_register.clear();
    }

    public static boolean isBound(ItemStack item) {
        return ItemScriptHelper.isItemscript(item) && ItemScriptHelper.getItemScriptContainer((ItemStack)item).bound;
    }

    public static boolean isItemscript(ItemStack item) {
        return ItemScriptHelper.getItemScriptContainer(item) != null;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (item == null) {
            return null;
        }
        String nbt = NMSHandler.getInstance().getItemHelper().getNbtData(item).getString("Denizen Item Script");
        if (nbt != null && !nbt.equals("")) {
            return item_scripts_by_hash_id.get(nbt);
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        for (String itemLore : item.getItemMeta().getLore()) {
            if (itemLore.startsWith("\u00a70id:")) {
                return item_scripts.get(itemLore.replace("\u00a70id:", ""));
            }
            if (!itemLore.startsWith(ItemScriptHashID)) continue;
            return item_scripts_by_hash_id.get(itemLore);
        }
        return null;
    }

    public static String createItemScriptID(ItemScriptContainer container) {
        String colors = ItemScriptHelper.createItemScriptID(container.getName());
        container.setHashID(colors);
        return colors;
    }

    public static String createItemScriptID(String name) {
        String script = name.toUpperCase();
        StringBuilder colors = new StringBuilder();
        colors.append(ItemScriptHashID);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = script.getBytes("UTF-8");
            md.update(bytes, 0, bytes.length);
            String hash = new BigInteger(1, md.digest()).toString(16);
            for (int i = 0; i < 16; ++i) {
                colors.append('\u00a7').append(hash.charAt(i));
            }
        }
        catch (Exception ex) {
            dB.echoError(ex);
            colors.append(ChatColor.BLUE);
        }
        return colors.toString();
    }

    @EventHandler
    public void specialRecipeClick(InventoryClickEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty() && ItemScriptContainer.shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType.equals((Object)InventoryType.SlotType.CRAFTING) || slotType.equals((Object)InventoryType.SlotType.RESULT)) {
            boolean clicked;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            if (slotType == InventoryType.SlotType.RESULT && inventory.getResult() != null && inventory.getResult().getData().getItemType() != Material.AIR) {
                PlayerCraftsItemScriptEvent scriptEvent = PlayerCraftsItemScriptEvent.instance;
                scriptEvent.inventory = inventory;
                scriptEvent.result = new dItem(inventory.getResult());
                dList recipeList = new dList();
                for (ItemStack item : inventory.getMatrix()) {
                    if (item != null) {
                        recipeList.add(new dItem(item.clone()).identify());
                        continue;
                    }
                    recipeList.add(new dItem(Material.AIR).identify());
                }
                scriptEvent.recipe = recipeList;
                scriptEvent.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player);
                scriptEvent.resultChanged = false;
                scriptEvent.fire();
                if (scriptEvent.cancelled) {
                    event.setCancelled(true);
                    return;
                }
                if (scriptEvent.resultChanged) {
                    event.setCurrentItem(scriptEvent.result.getItemStack());
                }
            }
            if ((clicked = slotType == InventoryType.SlotType.RESULT && event.isShiftClick() ? this.emulateSpecialRecipeResultShiftClick(inventory, player) : this.processSpecialRecipes(inventory, player)) && slotType.equals((Object)InventoryType.SlotType.RESULT)) {
                this.removeOneFromEachSlot(inventory, player);
            }
        }
    }

    public void removeOneFromEachSlot(final CraftingInventory inventory, final Player player) {
        final ItemStack[] matrix = inventory.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack is = matrix[i];
            matrix[i] = is == null ? new ItemStack(Material.AIR) : is.clone();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < matrix.length; ++i) {
                    if (matrix[i] == null) continue;
                    if (matrix[i].getAmount() == 0) {
                        matrix[i] = null;
                        continue;
                    }
                    matrix[i].setAmount(matrix[i].getAmount() - 1);
                    if (matrix[i].getAmount() != 0) continue;
                    matrix[i] = null;
                }
                inventory.setMatrix(matrix);
                player.updateInventory();
            }
        }, 0L);
    }

    @EventHandler
    public void specialRecipeDrag(InventoryDragEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty() && ItemScriptContainer.shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        for (Integer slot : event.getInventorySlots()) {
            if (slot >= 10) continue;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            this.processSpecialRecipes(inventory, player);
            break;
        }
    }

    public boolean processSpecialRecipes(final CraftingInventory inventory, final Player player) {
        ItemStack[] matrix1 = inventory.getMatrix();
        for (int i = 0; i < matrix1.length; ++i) {
            matrix1[i] = matrix1[i] == null ? new ItemStack(Material.AIR) : matrix1[i].clone();
        }
        dItem result1 = this.getSpecialRecipeResult(matrix1, player);
        boolean returnme = result1 != null;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                ItemStack[] matrix = inventory.getMatrix();
                for (int i = 0; i < matrix.length; ++i) {
                    matrix[i] = matrix[i] == null ? new ItemStack(Material.AIR) : matrix[i].clone();
                }
                dItem result = ItemScriptHelper.this.getSpecialRecipeResult(matrix, player);
                if (result != null) {
                    dList recipeList = new dList();
                    for (ItemStack item : matrix) {
                        if (item != null) {
                            recipeList.add(new dItem(item).identify());
                            continue;
                        }
                        recipeList.add(new dItem(Material.AIR).identify());
                    }
                    ItemRecipeFormedScriptEvent event = ItemRecipeFormedScriptEvent.instance;
                    event.result = result;
                    event.recipe = recipeList;
                    event.inventory = inventory;
                    event.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player);
                    event.cancelled = false;
                    event.resultChanged = false;
                    event.fire();
                    if (event.cancelled) {
                        inventory.setResult(null);
                    } else {
                        inventory.setResult(event.result.getItemStack());
                    }
                    player.updateInventory();
                }
            }
        }, 2L);
        return returnme;
    }

    public dItem getSpecialRecipeResult(ItemStack[] matrix, Player player) {
        block0: for (Map.Entry<ItemScriptContainer, List<dItem>> entry : ItemScriptContainer.specialrecipesMap.entrySet()) {
            for (int n = 0; n < 9; ++n) {
                dItem matrixN;
                dItem valueN = entry.getValue().get(n);
                dItem dItem2 = matrixN = matrix.length <= n || matrix[n] == null ? new dItem(Material.AIR) : new dItem(matrix[n].clone());
                if (valueN.isItemscript() != matrixN.isItemscript() || (valueN.isItemscript() && matrixN.isItemscript() ? !valueN.getScriptName().equalsIgnoreCase(matrixN.getScriptName()) : !valueN.getMaterial().matchesMaterialData(matrixN.getMaterial().getMaterialData()))) continue block0;
            }
            return entry.getKey().getItemFrom(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player), null);
        }
        block2: for (Map.Entry<ItemScriptContainer, List<dItem>> entry : ItemScriptContainer.shapelessRecipesMap.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                if (!this.containsAny(entry.getValue().get(i), matrix)) continue block2;
            }
            return entry.getKey().getItemFrom(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player), null);
        }
        return null;
    }

    public boolean containsAny(dItem item, ItemStack[] matrix) {
        String full = item.getFullString();
        for (int i = 0; i < matrix.length; ++i) {
            if (!full.equalsIgnoreCase(new dItem(matrix[i]).getFullString())) continue;
            return true;
        }
        return false;
    }

    public boolean emulateSpecialRecipeResultShiftClick(CraftingInventory inventory, Player player) {
        ItemStack[] matrix = inventory.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = matrix[i].clone();
        }
        dItem result = this.getSpecialRecipeResult(matrix, player);
        if (result != null) {
            int n;
            int lowestAmount = 0;
            for (n = 0; n < matrix.length; ++n) {
                if ((matrix[n].getAmount() <= 0 || matrix[n].getAmount() >= lowestAmount) && lowestAmount != 0) continue;
                lowestAmount = matrix[n].getAmount();
            }
            for (n = 0; n < matrix.length; ++n) {
                if (matrix[n].getAmount() <= 0) continue;
                matrix[n].setAmount(matrix[n].getAmount() - lowestAmount);
                if (matrix[n].getAmount() > 0) continue;
                matrix[n] = null;
            }
            if (lowestAmount > 1) {
                ItemStack resultStack = result.getItemStack().clone();
                resultStack.setAmount(lowestAmount * resultStack.getAmount());
                inventory.setMatrix(matrix);
                inventory.setResult(resultStack);
                player.updateInventory();
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void boundInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.PLAYER) {
            event.setCancelled(true);
            return;
        }
        if (!((Player)event.getInventory().getHolder()).getName().equalsIgnoreCase(event.getWhoClicked().getName())) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void boundInventoryDragEvent(InventoryDragEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getOldCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.PLAYER) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void boundDropItem(PlayerDropItemEvent event) {
        if (ItemScriptHelper.isBound(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
        }
    }
}

