/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.core.NPCNavigationSmartEvent;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NPCTags
implements Listener {
    public static Map<Integer, dLocation> previousLocations = new HashMap<Integer, dLocation>();

    public NPCTags(Denizen denizen) {
        if (Depends.citizens != null) {
            denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
            TagManager.registerTagEvents(this);
        }
    }

    @TagManager.TagEvents
    public void npcTags(ReplaceableTagEvent event) {
        if (!event.matches("npc") || event.replaced()) {
            return;
        }
        Attribute attribute = event.getAttributes();
        dNPC n = ((BukkitTagContext)event.getContext()).npc;
        if (attribute.hasContext(1)) {
            if (dNPC.matches(attribute.getContext(1))) {
                n = dNPC.valueOf(attribute.getContext(1));
            } else {
                if (!event.hasAlternative()) {
                    dB.echoError("Could not match '" + attribute.getContext(1) + "' to a valid NPC!");
                }
                return;
            }
        }
        if (n == null || !n.isValid()) {
            if (!event.hasAlternative()) {
                dB.echoError("Invalid or missing NPC for tag <" + event.raw_tag + ">!");
            }
            return;
        }
        event.setReplaced(n.getAttribute(attribute.fulfill(1)));
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc completes navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("complete navigation", null);
    }

    @EventHandler
    public void navBegin(NavigationBeginEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc begins navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("begin navigation", null);
        if (event.getNPC().getNavigator().getTargetType() == TargetType.ENTITY) {
            LivingEntity entity = (LivingEntity)event.getNPC().getNavigator().getEntityTarget().getTarget();
            if (event.getNPC().getNavigator().getEntityTarget().isAggressive() && !entity.isDead()) {
                dPlayer player = null;
                if (entity instanceof Player) {
                    player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
                }
                npc.action("attack", player);
                npc.action("attack on " + entity.getType().toString(), player);
            }
            previousLocations.put(event.getNPC().getId(), npc.getLocation());
        }
    }

    @EventHandler
    public void navCancel(NavigationCancelEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (NPCNavigationSmartEvent.IsActive()) {
            OldEventManager.doEvents(Arrays.asList("npc cancels navigation"), new BukkitScriptEntryData(null, npc), null);
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        npc.action("cancel navigation", null);
        npc.action("cancel navigation due to " + event.getCancelReason().toString(), null);
    }

    @EventHandler
    public void navStuck(NavigationStuckEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("action", new Element(event.getAction() == TeleportStuckAction.INSTANCE ? "teleport" : "none"));
        if (NPCNavigationSmartEvent.IsActive()) {
            List<String> determinations = OldEventManager.doEvents(Arrays.asList("npc stuck"), new BukkitScriptEntryData(null, npc), context);
            for (String determination : determinations) {
                if (determination.equalsIgnoreCase("none")) {
                    event.setAction(null);
                }
                if (!determination.equalsIgnoreCase("teleport")) continue;
                event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
            }
        }
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        String determination2 = npc.action("stuck", null, context);
        if (determination2.equalsIgnoreCase("none")) {
            event.setAction(null);
        }
        if (determination2.equalsIgnoreCase("teleport")) {
            event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
        }
    }
}

