/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.maps;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapView;

public abstract class MapObject {
    protected String xTag;
    protected String yTag;
    protected String visibilityTag = "true";
    protected Map<UUID, Integer> currentX = new HashMap<UUID, Integer>();
    protected Map<UUID, Integer> currentY = new HashMap<UUID, Integer>();
    protected Map<UUID, Boolean> currentVisibility = new HashMap<UUID, Boolean>();
    protected boolean debug;

    public MapObject(String xTag, String yTag, String visibilityTag, boolean debug) {
        this.xTag = xTag;
        this.yTag = yTag;
        this.visibilityTag = visibilityTag;
        this.debug = debug;
    }

    public void update(dPlayer player, UUID uuid) {
        this.currentX.put(uuid, (int)aH.getDoubleFrom(this.tag(this.xTag, player)));
        this.currentY.put(uuid, (int)aH.getDoubleFrom(this.tag(this.yTag, player)));
        this.currentVisibility.put(uuid, aH.getBooleanFrom(this.tag(this.visibilityTag, player)));
    }

    public int getX(dPlayer player, UUID uuid) {
        if (!this.currentX.containsKey(uuid)) {
            int x = (int)aH.getDoubleFrom(this.tag(this.xTag, player));
            this.currentX.put(uuid, x);
        }
        return this.currentX.get(uuid);
    }

    public int getY(dPlayer player, UUID uuid) {
        if (!this.currentY.containsKey(uuid)) {
            int y = (int)aH.getDoubleFrom(this.tag(this.yTag, player));
            this.currentY.put(uuid, y);
        }
        return this.currentY.get(uuid);
    }

    public boolean isVisibleTo(dPlayer player, UUID uuid) {
        if (!this.currentVisibility.containsKey(uuid)) {
            this.currentVisibility.put(uuid, this.tag(this.visibilityTag, player).equalsIgnoreCase("true"));
        }
        return this.currentVisibility.get(uuid);
    }

    protected String tag(String arg, dPlayer player) {
        return TagManager.tag(arg, new BukkitTagContext(player, player.getSelectedNPC(), false, null, this.debug, null));
    }

    public Map<String, Object> getSaveData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", this.xTag);
        data.put("y", this.yTag);
        data.put("visibility", this.visibilityTag);
        data.put("debug", this.debug ? "true" : "false");
        return data;
    }

    public abstract void render(MapView var1, MapCanvas var2, dPlayer var3, UUID var4);
}

