/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.core.CustomScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CustomObject
implements dObject,
Adjustable {
    public CustomScriptContainer container;
    public Map<String, String> vars;
    private String prefix = "Custom";

    @Fetchable(value="custom")
    public static CustomObject valueOf(String string, TagContext context) {
        String typeData;
        Object sc;
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(CustomObject.class, string, context);
        }
        if (string.startsWith("custom@")) {
            string = string.substring("custom@".length());
        }
        if ((sc = ScriptRegistry.getScriptContainer(typeData = string)) == null) {
            if (context == null || context.debug) {
                dB.echoError("Null script container for " + typeData);
            }
            return null;
        }
        if (!(sc instanceof CustomScriptContainer)) {
            if (context == null || context.debug) {
                dB.echoError("Wrong-typed script container for " + typeData);
            }
            return null;
        }
        return new CustomObject((CustomScriptContainer)sc, ((CustomScriptContainer)sc).getVars());
    }

    public static boolean matches(String string) {
        return string.startsWith("custom@");
    }

    public CustomObject(CustomScriptContainer type, Map<String, String> values) {
        this.container = type;
        this.vars = values;
    }

    @Override
    public String getObjectType() {
        return "Custom";
    }

    @Override
    public String identify() {
        StringBuilder outp = new StringBuilder();
        for (Map.Entry<String, String> var : this.vars.entrySet()) {
            outp.append(var.getKey() + "=" + var.getValue().replace(';', '\u2011') + ";");
        }
        return "custom@" + this.container.getName() + "[" + (outp.length() > 0 ? outp.substring(0, outp.length() - 1) : "") + "]";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return String.format("<G>%s='<A>%s<G>'  ", this.prefix, this.identify());
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        String res = this.vars.get(attribute.getAttribute(1));
        if (res == null) {
            if (this.container.hasPath("tags." + attribute.getAttribute(1))) {
                long ID2 = this.container.runTagScript(attribute.getAttribute(1), this, attribute.getScriptEntry() != null ? attribute.getScriptEntry().entryData : null);
                List<String> outcomes = DetermineCommand.getOutcome(ID2);
                if (outcomes == null) {
                    return null;
                }
                return ObjectFetcher.pickObjectFor(outcomes.get(0)).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        return ObjectFetcher.pickObjectFor(res).getAttribute(attribute.fulfill(1));
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String name = CoreUtilities.toLowerCase(mechanism.getName());
        String value = mechanism.getValue().asString();
        if (this.container.hasPath("mechanisms." + name)) {
            long ID2 = this.container.runMechScript(name, this, value);
            List<String> outcomes = DetermineCommand.getOutcome(ID2);
            if (outcomes == null) {
                return;
            }
            CustomObject co = CustomObject.valueOf(outcomes.get(0), null);
            this.container = co.container;
            this.vars = co.vars;
        } else {
            this.vars.remove(name);
            this.vars.put(name, value);
        }
    }
}

