/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.queues;

import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.CommandExecuter;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.Delayable;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ScriptEngine {
    private final CommandExecuter commandExecuter = new CommandExecuter();

    boolean shouldHold(ScriptQueue scriptQueue) {
        if (scriptQueue instanceof Delayable && ((Delayable)((Object)scriptQueue)).isPaused()) {
            return true;
        }
        if (scriptQueue.getLastEntryExecuted() != null && scriptQueue.getLastEntryExecuted().shouldWaitFor()) {
            if (!(scriptQueue instanceof Delayable)) {
                dB.echoDebug((Debuggable)scriptQueue.getLastEntryExecuted(), "Forcing queue " + scriptQueue.id + " into a timed queue...");
                scriptQueue.forceToTimed(null);
                return true;
            }
            return true;
        }
        return false;
    }

    public void revolve(ScriptQueue scriptQueue) {
        if (this.shouldHold(scriptQueue)) {
            return;
        }
        ScriptEntry scriptEntry = scriptQueue.getNext();
        while (scriptEntry != null) {
            scriptEntry.setSendingQueue(scriptQueue);
            try {
                this.getScriptExecuter().execute(scriptEntry);
            }
            catch (Throwable e) {
                dB.echoError(scriptEntry.getResidingQueue(), "Woah! An exception has been called with this command!");
                dB.echoError(scriptEntry.getResidingQueue(), e);
            }
            scriptQueue.setLastEntryExecuted(scriptEntry);
            if (scriptQueue instanceof Delayable && (((Delayable)((Object)scriptQueue)).isDelayed() || ((Delayable)((Object)scriptQueue)).isPaused()) || !scriptEntry.isInstant()) break;
            if (this.shouldHold(scriptQueue)) {
                return;
            }
            scriptEntry = scriptQueue.getNext();
        }
    }

    public CommandExecuter getScriptExecuter() {
        return this.commandExecuter;
    }
}

