/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CoreUtilities {
    static Random random = new Random();
    protected static FilenameFilter scriptsFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.startsWith(".")) {
                return false;
            }
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSCRIPT");
        }
    };

    public static Random getRandom() {
        return random;
    }

    public static List<File> listDScriptFiles(File dir) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(CoreUtilities.listDScriptFiles(file));
        }
        return files;
    }

    public static List<String> split(String str, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
        }
        strings.add(str.substring(start, str.length()));
        return strings;
    }

    public static String concat(List<String> str, String split) {
        StringBuilder sb = new StringBuilder();
        if (str.size() > 0) {
            sb.append(str.get(0));
        }
        for (int i = 1; i < str.size(); ++i) {
            sb.append(split).append(str.get(i));
        }
        return sb.toString();
    }

    public static List<String> split(String str, char c, int max) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
            if (strings.size() + 1 == max) break;
        }
        strings.add(str.substring(start, str.length()));
        if (dB.verbose) {
            dB.log("Splitting " + str + " around " + c + " limited to " + max + " returns " + CoreUtilities.concat(strings, ":::"));
        }
        return strings;
    }

    public static String toLowerCase(String input) {
        char[] data = input.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 'A' || data[i] > 'Z') continue;
            int n = i;
            data[n] = (char)(data[n] - -32);
        }
        return new String(data);
    }

    public static String getXthArg(int argc, String args) {
        char[] data = args.toCharArray();
        StringBuilder nArg = new StringBuilder();
        int arg = 0;
        boolean x = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                if (++arg <= argc) continue;
                return nArg.toString();
            }
            if (arg != argc) continue;
            nArg.append(data[i]);
        }
        return nArg.toString();
    }

    public static boolean xthArgEquals(int argc, String args, String input) {
        char[] data = args.toCharArray();
        char[] data2 = input.toCharArray();
        int arg = 0;
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                ++arg;
                continue;
            }
            if (arg != argc) continue;
            if (x == data2.length) {
                return false;
            }
            if (data2[x++] == data[i]) continue;
            return false;
        }
        return x == data2.length;
    }

    public static String getClosestOption(List<String> strs, String opt) {
        int minDist = Integer.MAX_VALUE;
        opt = CoreUtilities.toLowerCase(opt);
        String closest = "";
        for (String cmd : strs) {
            String comp = CoreUtilities.toLowerCase(cmd);
            int distance = CoreUtilities.getLevenshteinDistance(opt, comp);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = comp;
        }
        return closest;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }
}

