/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.bukkit.ListenerCancelEvent;
import net.aufdemrand.denizen.events.bukkit.ListenerFinishEvent;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.AbstractListenerType;
import net.aufdemrand.denizen.listeners.core.BlockListenerInstance;
import net.aufdemrand.denizen.listeners.core.BlockListenerType;
import net.aufdemrand.denizen.listeners.core.ItemDropListenerInstance;
import net.aufdemrand.denizen.listeners.core.ItemDropListenerType;
import net.aufdemrand.denizen.listeners.core.ItemListenerInstance;
import net.aufdemrand.denizen.listeners.core.ItemListenerType;
import net.aufdemrand.denizen.listeners.core.KillListenerInstance;
import net.aufdemrand.denizen.listeners.core.KillListenerType;
import net.aufdemrand.denizen.listeners.core.TravelListenerInstance;
import net.aufdemrand.denizen.listeners.core.TravelListenerType;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.interfaces.dRegistry;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ListenerRegistry
implements dRegistry,
Listener {
    private Map<String, Map<String, AbstractListener>> listeners = new ConcurrentHashMap<String, Map<String, AbstractListener>>();
    private Map<String, AbstractListenerType> types = new ConcurrentHashMap<String, AbstractListenerType>();

    public void addListenerFor(dPlayer player, AbstractListener instance, String id) {
        if (player == null || id == null) {
            return;
        }
        Map<String, AbstractListener> playerListeners = this.listeners.containsKey(player.getName()) ? this.listeners.get(player.getName()) : new HashMap<String, AbstractListener>();
        playerListeners.put(CoreUtilities.toLowerCase(id), instance);
        this.listeners.put(player.getName(), playerListeners);
    }

    public void removeListenerFor(dPlayer player, String id) {
        if (player == null || id == null) {
            return;
        }
        if (!this.listeners.containsKey(player.getName())) {
            return;
        }
        Map<String, AbstractListener> playerListeners = this.listeners.get(player.getName());
        playerListeners.remove(CoreUtilities.toLowerCase(id));
        this.listeners.put(player.getName(), playerListeners);
    }

    public void cancel(dPlayer player, String id) {
        if (player == null || id == null) {
            return;
        }
        this.removeListenerFor(player, id);
        Bukkit.getPluginManager().callEvent((Event)new ListenerCancelEvent(player, id));
    }

    public void finish(dPlayer player, dNPC npc, String id, dScript on_finish) {
        if (player == null || id == null) {
            return;
        }
        this.removeListenerFor(player, id);
        if (on_finish != null) {
            try {
                ((TaskScriptContainer)on_finish.getContainer()).runTaskScript(new BukkitScriptEntryData(player, npc), null);
            }
            catch (Exception e) {
                dB.echoError("Tried to run the finish task for: " + id + "/" + player.getName() + "," + "but it seems not to be valid!");
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new ListenerFinishEvent(player, id));
    }

    public AbstractListener getListenerFor(dPlayer player, String listenerId) {
        Map<String, AbstractListener> playerListeners;
        if (this.listeners.containsKey(player.getName()) && (playerListeners = this.listeners.get(player.getName())).containsKey(CoreUtilities.toLowerCase(listenerId))) {
            return playerListeners.get(CoreUtilities.toLowerCase(listenerId));
        }
        return null;
    }

    public Map<String, AbstractListener> getListenersFor(dPlayer player) {
        if (this.listeners.containsKey(player.getName())) {
            return this.listeners.get(player.getName());
        }
        return null;
    }

    @Override
    public boolean register(String registrationName, RegistrationableInstance listenerType) {
        this.types.put(registrationName, (AbstractListenerType)listenerType);
        return false;
    }

    @Override
    public void registerCoreMembers() {
        new BlockListenerType().activate().as("BLOCK").withClass(BlockListenerInstance.class);
        new ItemListenerType().activate().as("ITEM").withClass(ItemListenerInstance.class);
        new KillListenerType().activate().as("KILL").withClass(KillListenerInstance.class);
        new ItemDropListenerType().activate().as("ITEMDROP").withClass(ItemDropListenerInstance.class);
        new TravelListenerType().activate().as("TRAVEL").withClass(TravelListenerInstance.class);
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void disableCoreMembers() {
        for (RegistrationableInstance registrationableInstance : this.types.values()) {
            try {
                registrationableInstance.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + registrationableInstance.getClass().getName() + "'!");
                dB.echoError(e);
            }
        }
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.types.containsValue(clazz)) {
            for (RegistrationableInstance registrationableInstance : this.types.values()) {
                if (registrationableInstance.getClass() != clazz) continue;
                return (T)((RegistrationableInstance)clazz.cast(registrationableInstance));
            }
        }
        return null;
    }

    @Override
    public AbstractListenerType get(String listenerType) {
        if (this.types.containsKey(listenerType.toUpperCase())) {
            return this.types.get(listenerType.toUpperCase());
        }
        return null;
    }

    public Map<String, AbstractListenerType> list() {
        return this.types;
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        Denizen denizen = DenizenAPI.getCurrentInstance();
        dPlayer player = new dPlayer(event.getPlayer());
        if (!denizen.getSaves().contains("Listeners." + player.getSaveName())) {
            return;
        }
        Set inProgress = denizen.getSaves().getConfigurationSection("Listeners." + player.getSaveName()).getKeys(false);
        if (inProgress.isEmpty()) {
            return;
        }
        String path = "Listeners." + player.getSaveName() + ".";
        for (String listenerId : inProgress) {
            try {
                String type = denizen.getSaves().getString(path + listenerId + ".Listener Type");
                dNPC npc = null;
                if (denizen.getSaves().contains(path + listenerId + ".Linked NPCID")) {
                    npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getById(denizen.getSaves().getInt(path + listenerId + ".Linked NPCID")));
                }
                if (this.get(type) == null) {
                    return;
                }
                dB.log(event.getPlayer().getName() + " has a LISTENER in progress. Loading '" + listenerId + "'.");
                this.get(type).createInstance(dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer()), listenerId).load(dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer()), npc, listenerId, type);
            }
            catch (Exception e) {
                dB.log(event.getPlayer() + " has a saved listener named '" + listenerId + "' that may be corrupt. Skipping for now, but perhaps check the contents of your saves.yml for problems?");
            }
        }
    }

    public void deconstructPlayer(dPlayer player) {
        Denizen denizen = DenizenAPI.getCurrentInstance();
        denizen.getSaves().set("Listeners." + player.getSaveName(), null);
        if (!this.listeners.containsKey(player.getName())) {
            return;
        }
        for (Map.Entry<String, AbstractListener> entry : this.getListenersFor(player).entrySet()) {
            dB.log(player.getName() + " has a LISTENER in progress. Saving '" + entry.getKey() + "'.");
            entry.getValue().save();
        }
        this.listeners.remove(player);
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.deconstructPlayer(dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer()));
    }
}

