/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;

public class EntityAI
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).isLivingEntity();
    }

    public static EntityAI getFrom(dObject entity) {
        if (!EntityAI.describes(entity)) {
            return null;
        }
        return new EntityAI((dEntity)entity);
    }

    private EntityAI(dEntity ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(!NMSHandler.getInstance().getEntityHelper().isAIDisabled(this.entity.getBukkitEntity()));
    }

    @Override
    public String getPropertyId() {
        return "has_ai";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_ai")) {
            return new Element(!NMSHandler.getInstance().getEntityHelper().isAIDisabled(this.entity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("has_ai") || mechanism.matches("toggle_ai")) && mechanism.requireBoolean()) {
            NMSHandler.getInstance().getEntityHelper().toggleAI(this.entity.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
    }
}

