/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBaseColor
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        if (item instanceof dItem) {
            Material material = ((dItem)item).getItemStack().getType();
            return material == Material.BANNER || material == Material.WALL_BANNER || material == Material.STANDING_BANNER || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && material == Material.SHIELD;
        }
        return false;
    }

    public static ItemBaseColor getFrom(dObject item) {
        if (!ItemBaseColor.describes(item)) {
            return null;
        }
        return new ItemBaseColor((dItem)item);
    }

    private ItemBaseColor(dItem item) {
        this.item = item;
    }

    private DyeColor getBaseColor() {
        ItemMeta itemMeta = this.item.getItemStack().getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            return ((Banner)((BlockStateMeta)itemMeta).getBlockState()).getBaseColor();
        }
        return ((BannerMeta)itemMeta).getBaseColor();
    }

    private void setBaseColor(DyeColor color) {
        ItemStack itemStack = this.item.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            Banner banner = (Banner)((BlockStateMeta)itemMeta).getBlockState();
            banner.setBaseColor(color);
            banner.update();
            ((BlockStateMeta)itemMeta).setBlockState((BlockState)banner);
        } else {
            ((BannerMeta)itemMeta).setBaseColor(color);
        }
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("base_color")) {
            DyeColor baseColor = this.getBaseColor();
            if (baseColor != null) {
                return new Element(baseColor.name()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        DyeColor baseColor = this.getBaseColor();
        if (baseColor != null) {
            return baseColor.name();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "base_color";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("base_color")) {
            this.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
    }
}

