/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemNBT
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getMaterial().getMaterial() != Material.AIR;
    }

    public static ItemNBT getFrom(dObject item) {
        if (!ItemNBT.describes(item)) {
            return null;
        }
        return new ItemNBT((dItem)item);
    }

    private ItemNBT(dItem item) {
        this.item = item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_nbt")) {
            return new Element(CustomNBT.hasCustomNBT(this.item.getItemStack(), attribute.getContext(1), "Denizen NBT")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("nbt_keys")) {
            return new dList(CustomNBT.listNBT(this.item.getItemStack(), "Denizen NBT")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("nbt")) {
            return new Element(CustomNBT.getCustomNBT(this.item.getItemStack(), attribute.getContext(1), "Denizen NBT")).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ItemStack itemStack = this.item.getItemStack();
        List<String> nbtKeys = CustomNBT.listNBT(itemStack, "Denizen NBT");
        if (nbtKeys != null && !nbtKeys.isEmpty()) {
            dList list = new dList();
            for (String key : nbtKeys) {
                list.add(key + "/" + CustomNBT.getCustomNBT(itemStack, key, "Denizen NBT"));
            }
            return list.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "nbt";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("nbt")) {
            dList list = mechanism.getValue().asType(dList.class);
            ItemStack itemStack = this.item.getItemStack();
            for (String string : list) {
                String[] split = string.split("/", 2);
                itemStack = CustomNBT.addCustomNBT(itemStack, split[0], split[1], "Denizen NBT");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

