/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ZapCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("step") && arg.hasPrefix() && arg.getPrefix().matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.getPrefix().asType(dScript.class));
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("step")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("step")) {
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("script", scriptEntry.getScript());
        if (!((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() || !((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        final dScript script = (dScript)scriptEntry.getObject("script");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dB.report(scriptEntry, this.getName(), ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().debug() + script.debug() + (scriptEntry.hasObject("step") ? scriptEntry.getElement("step").debug() : aH.debugObj("step", "++ (inc)")) + (duration != null ? duration.debug() : ""));
        String step = scriptEntry.hasObject("step") ? scriptEntry.getElement("step").asString() : null;
        String currentStep = InteractScriptHelper.getCurrentStep(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), script.getName());
        if (step == null) {
            step = aH.matchesInteger(currentStep) ? String.valueOf(aH.getIntegerFrom(currentStep) + 1) : "1";
        }
        if (step.equalsIgnoreCase(currentStep)) {
            dB.echoError(scriptEntry.getResidingQueue(), "Zapping to own current step!");
            return;
        }
        if (durations.containsKey(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getSaveName() + "," + script.getName())) {
            try {
                DenizenAPI.getCurrentInstance().getServer().getScheduler().cancelTask(durations.get(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getSaveName() + "," + script.getName()).intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (duration != null && duration.getSeconds() > 0.0) {
            scriptEntry.addObject("step", new Element(currentStep));
            scriptEntry.addObject("duration", Duration.ZERO);
            long delay = (long)(duration.getSeconds() * 20.0);
            dB.log("Setting delayed task 'RESET ZAP' for '" + script.identify() + "'");
            durations.put(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getSaveName() + "," + script.getName(), DenizenAPI.getCurrentInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    dB.log("Running delayed task 'RESET ZAP' for '" + script.identify() + "'");
                    try {
                        durations.remove(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getSaveName() + "," + script.getName().toUpperCase());
                        ZapCommand.this.execute(scriptEntry);
                    }
                    catch (CommandExecutionException e) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Could not run delayed task!");
                        dB.echoError(scriptEntry.getResidingQueue(), e);
                    }
                }
            }, delay));
        }
        DenizenAPI.getCurrentInstance().getSaves().set("Players." + ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getSaveName() + ".Scripts." + script.getName().toUpperCase() + "." + "Current Step", (Object)step);
    }
}

