/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.DenizenAliasHelpTopic;
import net.aufdemrand.denizen.utilities.DenizenCommand;
import net.aufdemrand.denizen.utilities.DenizenCommandHelpTopic;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.HelpCommand;
import org.bukkit.event.Listener;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CommandScriptHelper
implements Listener {
    private static Map<String, DenizenCommand> denizenCommands = new ConcurrentHashMap<String, DenizenCommand>(8, 0.9f, 1);
    private static Map<String, Command> overriddenCommands = new HashMap<String, Command>();
    private static Map<String, HelpTopic> overriddenHelpTopics = new HashMap<String, HelpTopic>();
    private static Map<String, Command> knownCommands = null;
    private static Map<String, HelpTopic> helpTopics = null;
    private static boolean hasCommandInformation = true;

    public CommandScriptHelper() {
        try {
            Server server = DenizenAPI.getCurrentInstance().getServer();
            server.getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
            Field commandMapField = server.getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(server);
            Field knownCommandsField = commandMap.getClass().getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            knownCommands = (Map)knownCommandsField.get(commandMap);
            HelpMap helpMap = server.getHelpMap();
            Field helpTopicsField = helpMap.getClass().getDeclaredField("helpTopics");
            helpTopicsField.setAccessible(true);
            helpTopics = (Map)helpTopicsField.get(helpMap);
            if (Settings.overrideHelp()) {
                new BukkitRunnable(){

                    public void run() {
                        if (knownCommands.get("help") instanceof HelpCommand) {
                            return;
                        }
                        knownCommands.put("help", knownCommands.get("bukkit:help"));
                        helpTopics.put("/help", helpTopics.get("/bukkit:help"));
                    }
                }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
            }
        }
        catch (Exception e) {
            dB.echoError("Error getting the server's command information! Are you running a non-CraftBukkit server?");
            dB.echoError("Command scripts will not function!");
            hasCommandInformation = false;
        }
    }

    public static void removeDenizenCommands() {
        if (!hasCommandInformation) {
            return;
        }
        for (String command : denizenCommands.keySet()) {
            knownCommands.remove(command);
            helpTopics.remove(command);
            if (!overriddenCommands.containsKey(command)) continue;
            knownCommands.put(command, overriddenCommands.get(command));
            if (!overriddenHelpTopics.containsKey(command)) continue;
            helpTopics.put(command, overriddenHelpTopics.get(command));
        }
        denizenCommands.clear();
    }

    public static void registerDenizenCommand(DenizenCommand command) {
        if (!hasCommandInformation) {
            return;
        }
        String name = command.getName();
        if (!denizenCommands.containsKey(name)) {
            CommandScriptHelper.forceCommand(name, command, (HelpTopic)new DenizenCommandHelpTopic(command));
            for (String alias : command.getAliases()) {
                if (denizenCommands.containsKey(alias)) continue;
                CommandScriptHelper.forceCommand(alias, command, new DenizenAliasHelpTopic("/" + alias, name, DenizenAPI.getCurrentInstance().getServer().getHelpMap()));
            }
        }
    }

    private static void forceCommand(String name, DenizenCommand command, HelpTopic helpTopic) {
        if (knownCommands.containsKey(name)) {
            overriddenCommands.put(name, knownCommands.get(name));
            knownCommands.remove(name);
            if (helpTopics.containsKey(name)) {
                overriddenHelpTopics.put(name, helpTopics.get(name));
                helpTopics.remove(name);
            }
        }
        knownCommands.put(name, command);
        helpTopics.put(helpTopic.getName(), helpTopic);
        denizenCommands.put(name, command);
    }

    private static class IsCommandTopicPredicate
    implements Predicate<HelpTopic> {
        private IsCommandTopicPredicate() {
        }

        @Override
        public boolean apply(HelpTopic topic) {
            return topic.getName().charAt(0) == '/';
        }
    }
}

