/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.utilities.dExternalRunnable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.interfaces.dExternal;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceCompilerImpl;
import org.bukkit.ChatColor;

public class RuntimeCompiler {
    Denizen denizen;
    private final File externalsFolder;
    private static final File pluginsFolder = new File("plugins");
    private static final FilenameFilter jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return CoreUtilities.toLowerCase(name).endsWith(".jar");
        }
    };
    private static final FilenameFilter javaFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return CoreUtilities.toLowerCase(name).endsWith(".java");
        }
    };
    public static ArrayList<dExternal> loadedExternals = new ArrayList();
    List<String> dependencies;
    public int i = 0;

    public RuntimeCompiler(Denizen denizen) {
        this.denizen = denizen;
        this.externalsFolder = new File(denizen.getDataFolder() + File.separator + "externals");
    }

    public void loader() {
        File file;
        dB.log("Loading external dependencies for run-time compiler.");
        this.dependencies = new ArrayList<String>();
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals" + File.separator + "dependencies");
            for (File f : file.listFiles(jarFilter)) {
                this.dependencies.add(f.getPath());
                dB.log("Loaded  " + f.getName());
            }
        }
        catch (Exception error) {
            dB.log("No dependencies to load or error loading dependencies: " + error.getMessage());
        }
        dB.log("Loading plugins as dependencies for run-time compiler.");
        for (File f : pluginsFolder.listFiles(jarFilter)) {
            this.dependencies.add(f.getPath());
            dB.log("Loaded  " + f.getName());
        }
        dB.log("Attempting to add CraftBukkit as dependency for run-time compiler.");
        try {
            file = new File(".");
            for (File f : file.listFiles(jarFilter)) {
                this.dependencies.add(f.getPath());
                dB.log("Loaded  " + f.getName());
            }
        }
        catch (Exception error) {
            dB.log("Could not find CraftBukkit jar or error reading it: " + error.getMessage());
        }
        if (!this.externalsFolder.exists() || this.externalsFolder.list().length == 0) {
            return;
        }
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals");
            File[] files = file.listFiles(javaFilter);
            if (files != null && files.length > 0) {
                for (File f : files) {
                    String fileName = f.getName();
                    dB.log("Processing '" + fileName + "'... ");
                    JavaSourceCompilerImpl javaSourceCompiler = new JavaSourceCompilerImpl();
                    JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit();
                    if (!this.dependencies.isEmpty()) {
                        compilationUnit.addClassPathEntries(this.dependencies);
                    }
                    try {
                        compilationUnit.addJavaSource(fileName.replace(".java", ""), this.readFile(f.getAbsolutePath()));
                        ClassLoader classLoader = javaSourceCompiler.compile(compilationUnit, new String[0]);
                        Class<?> load = classLoader.loadClass(fileName.replace(".java", ""));
                        dExternal loadedClass = (dExternal)load.newInstance();
                        loadedClass.load();
                        loadedExternals.add(loadedClass);
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalStateException) {
                            dB.echoError("No JDK found! External .java files will not be loaded.");
                            dB.echoError(e);
                            continue;
                        }
                        dB.echoError(ChatColor.RED + "Error compiling " + fileName + "!");
                        dB.echoError(e);
                    }
                }
                dB.echoApproval("All externals loaded!");
            }
        }
        catch (Exception error) {
            dB.echoError(error);
        }
    }

    public void runString(String input) {
        try {
            ++this.i;
            JavaSourceCompilerImpl javaSourceCompiler = new JavaSourceCompilerImpl();
            JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit();
            if (!this.dependencies.isEmpty()) {
                compilationUnit.addClassPathEntries(this.dependencies);
            }
            String complete = "import net.aufdemrand.denizen.utilities.debugging.dB;\npublic class CodeTester" + this.i + " extends net.aufdemrand.denizen.utilities.dExternalRunnable {\n" + "public void unload() {}\npublic void load() {}\n" + "public void run() {\n" + input + "\n}\n}";
            compilationUnit.addJavaSource("CodeTester" + this.i, complete);
            ClassLoader classLoader = javaSourceCompiler.compile(compilationUnit, new String[0]);
            Class<?> load = classLoader.loadClass("CodeTester" + this.i);
            dExternalRunnable loadedClass = (dExternalRunnable)load.newInstance();
            loadedClass.load();
            loadedClass.run();
            loadedClass.unload();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public void reload() {
        for (dExternal external : loadedExternals) {
            external.unload();
        }
        loadedExternals.clear();
        this.loader();
    }

    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }
}

