/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.commands.npc.EngageCommand;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;

public class TriggerTrait
extends Trait
implements Listener {
    @Persist(value="enabled", collectionType=ConcurrentHashMap.class)
    private Map<String, Boolean> enabled = new ConcurrentHashMap<String, Boolean>(8, 0.9f, 1);
    @Persist(value="duration", collectionType=ConcurrentHashMap.class)
    private Map<String, Double> duration = new ConcurrentHashMap<String, Double>(8, 0.9f, 1);
    @Persist(value="cooldowntype", collectionType=ConcurrentHashMap.class)
    private Map<String, TriggerRegistry.CooldownType> type = new ConcurrentHashMap<String, TriggerRegistry.CooldownType>(8, 0.9f, 1);
    @Persist(value="radius", collectionType=ConcurrentHashMap.class)
    private Map<String, Integer> radius = new ConcurrentHashMap<String, Integer>(8, 0.9f, 1);

    public void report() {
        dB.log("enabled: " + this.enabled.entrySet().toString());
        dB.log("duration: " + this.duration.entrySet().toString());
        dB.log("type: " + this.type.entrySet().toString());
        dB.log("radius: " + this.radius.entrySet().toString());
    }

    public TriggerTrait() {
        super("triggers");
        for (String triggerName : DenizenAPI.getCurrentInstance().getTriggerRegistry().list().keySet()) {
            if (this.enabled.containsKey(triggerName)) continue;
            this.enabled.put(triggerName, Settings.triggerEnabled(triggerName));
        }
    }

    public void onSpawn() {
        for (String triggerName : DenizenAPI.getCurrentInstance().getTriggerRegistry().list().keySet()) {
            if (this.enabled.containsKey(triggerName)) continue;
            this.enabled.put(triggerName, Settings.triggerEnabled(triggerName));
        }
    }

    public String toggleTrigger(String triggerName, boolean toggle) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            this.enabled.put(triggerName.toUpperCase(), toggle);
            return triggerName + " trigger is now " + (toggle ? "enabled." : "disabled.");
        }
        return triggerName + " trigger not found!";
    }

    public String toggleTrigger(String triggerName) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            if (this.enabled.get(triggerName.toUpperCase()).booleanValue()) {
                this.enabled.put(triggerName.toUpperCase(), false);
                return triggerName + " trigger is now disabled.";
            }
            this.enabled.put(triggerName.toUpperCase(), true);
            return triggerName + " trigger is now enabled.";
        }
        return triggerName + " trigger not found!";
    }

    public boolean hasTrigger(String triggerName) {
        return this.enabled.containsKey(triggerName.toUpperCase()) && this.enabled.get(triggerName.toUpperCase()) != false;
    }

    public boolean isEnabled(String triggerName) {
        if (!DenizenAPI.getDenizenNPC(this.npc).getAssignmentTrait().hasAssignment()) {
            return false;
        }
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            return this.enabled.get(triggerName.toUpperCase());
        }
        return false;
    }

    public void setLocalCooldown(String triggerName, double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.duration.put(triggerName.toUpperCase(), value);
    }

    public double getCooldownDuration(String triggerName) {
        if (this.duration.containsKey(triggerName.toUpperCase())) {
            return this.duration.get(triggerName.toUpperCase());
        }
        return Settings.triggerDefaultCooldown(triggerName);
    }

    public TriggerRegistry.CooldownType getCooldownType(String triggerName) {
        try {
            if (this.type.containsKey(triggerName.toUpperCase())) {
                return this.type.get(triggerName.toUpperCase());
            }
            return TriggerRegistry.CooldownType.valueOf(Settings.triggerDefaultCooldownType(triggerName).toUpperCase());
        }
        catch (Exception e) {
            return TriggerRegistry.CooldownType.PLAYER;
        }
    }

    public void setLocalRadius(String triggerName, int value) {
        this.radius.put(triggerName.toUpperCase(), value);
    }

    public double getRadius(String triggerName) {
        if (this.radius.containsKey(triggerName.toUpperCase())) {
            return this.radius.get(triggerName.toUpperCase()).intValue();
        }
        return Settings.triggerDefaultRange(triggerName);
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Triggers");
        paginator.addLine("<e>Key: <a>Name  <b>Status  <c>Cooldown  <d>Cooldown Type  <e>(Radius)");
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            String line = "<a> " + entry.getKey() + "<b> " + (entry.getValue() != false ? "Enabled" : "Disabled") + "<c> " + this.getCooldownDuration(entry.getKey()) + "<d> " + this.getCooldownType(entry.getKey()).name() + "<e> " + (this.getRadius(entry.getKey()) == -1.0 ? "" : Double.valueOf(this.getRadius(entry.getKey())));
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public boolean triggerCooldownOnly(AbstractTrigger triggerClass, dPlayer player) {
        if (!DenizenAPI.getCurrentInstance().getTriggerRegistry().checkCooldown(this.npc, player, triggerClass, this.getCooldownType(triggerClass.getName()))) {
            return false;
        }
        if (EngageCommand.getEngaged(this.npc)) {
            return false;
        }
        DenizenAPI.getCurrentInstance().getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()), this.getCooldownType(triggerClass.getName()));
        return true;
    }

    public TriggerContext trigger(AbstractTrigger triggerClass, dPlayer player) {
        return this.trigger(triggerClass, player, null);
    }

    public TriggerContext trigger(AbstractTrigger triggerClass, dPlayer player, Map<String, dObject> context) {
        String trigger_type = triggerClass.getName();
        if (!DenizenAPI.getCurrentInstance().getTriggerRegistry().checkCooldown(this.npc, player, triggerClass, this.getCooldownType(trigger_type))) {
            return new TriggerContext(false);
        }
        if (context == null) {
            context = new HashMap<String, dObject>();
        }
        if (EngageCommand.getEngaged(this.npc)) {
            context.put("trigger_type", new Element(trigger_type));
            if (!dNPCRegistry.getDenizen(this.npc).action("unavailable", player, context).equalsIgnoreCase("available")) {
                return new TriggerContext(false);
            }
        }
        DenizenAPI.getCurrentInstance().getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(trigger_type), this.getCooldownType(trigger_type));
        String determination = dNPCRegistry.getDenizen(this.npc).action(trigger_type, player, context);
        return new TriggerContext(determination, true);
    }

    public class TriggerContext {
        String determination;
        boolean triggered;

        public TriggerContext(boolean triggered) {
            this.triggered = triggered;
        }

        public TriggerContext(String determination, boolean triggered) {
            this.determination = determination;
            this.triggered = triggered;
        }

        public boolean hasDetermination() {
            return this.determination != null && !this.determination.equalsIgnoreCase("none");
        }

        public String getDetermination() {
            return this.determination;
        }

        public boolean wasTriggered() {
            return this.triggered;
        }
    }
}

