/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.core.ProcedureScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.NaturalOrderComparator;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class dList
extends ArrayList<String>
implements dObject {
    public static final char internal_escape_char = '\u0005';
    public static final String internal_escape = String.valueOf('\u0005');
    private String prefix = "List";
    public String flag = null;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dList valueOf(String string) {
        return dList.valueOf(string, null);
    }

    @Fetchable(value="li, fl")
    public static dList valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        dList list = DenizenCore.getImplementation().valueOfFlagdList(string);
        if (list != null) {
            return list;
        }
        return new dList(string.startsWith("li@") ? string.substring(3) : string);
    }

    public static boolean matches(String arg) {
        boolean flag = DenizenCore.getImplementation().matchesFlagdList(arg);
        return flag || arg.contains("|") || arg.contains(internal_escape) || arg.startsWith("li@");
    }

    public dList(Collection<? extends dObject> dObjectList) {
        for (dObject dObject2 : dObjectList) {
            this.add(dObject2.identify());
        }
    }

    public dList() {
    }

    public dList(String items) {
        if (items != null && items.length() > 0) {
            int brackets = 0;
            int start = 0;
            for (int i = 0; i < items.length(); ++i) {
                char chr = items.charAt(i);
                if (chr == '[') {
                    ++brackets;
                    continue;
                }
                if (chr == ']') {
                    if (brackets <= 0) continue;
                    --brackets;
                    continue;
                }
                if (brackets != 0 || chr != '|' && chr != '\u0005') continue;
                this.add(items.substring(start, i));
                start = i + 1;
            }
            if (start < items.length()) {
                this.add(items.substring(start, items.length()));
            }
        }
    }

    public dList(String flag, boolean is_flag, List<String> flag_contents) {
        if (is_flag) {
            this.flag = flag;
        }
        this.addAll(flag_contents);
    }

    public dList(List<String> items) {
        if (items != null) {
            this.addAll(items);
        }
    }

    public dList(Set<? extends Object> items) {
        if (items != null) {
            for (Object object : items) {
                this.add(object.toString());
            }
        }
    }

    public dList(List<String> items, String prefix) {
        for (String element : items) {
            this.add(prefix + element);
        }
    }

    public dList addObjects(List<dObject> dObjects) {
        for (dObject obj : dObjects) {
            this.add(obj.identify());
        }
        return this;
    }

    public String[] toArray() {
        return this.toArray(this.size());
    }

    public String[] toArray(int arraySize) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            list.add(string);
        }
        return list.toArray(new String[arraySize]);
    }

    public boolean containsObjectsFrom(Class<? extends dObject> dClass) {
        for (String element : this) {
            if (!ObjectFetcher.checkMatch(dClass, element)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            for (Enum value : values) {
                if (!value.name().equalsIgnoreCase(string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends dObject> List<T> filter(Class<T> dClass) {
        return this.filter(dClass, null);
    }

    public <T extends dObject> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        ArrayList<T> results = new ArrayList<T>();
        for (String element : this) {
            try {
                T object;
                if (!ObjectFetcher.checkMatch(dClass, element) || (object = ObjectFetcher.getObjectFrom(dClass, element, entry == null ? DenizenCore.getImplementation().getTagContext(null) : entry.entryData.getTagContext())) == null) continue;
                results.add(object);
            }
            catch (Exception e) {
                dB.echoError(e);
            }
        }
        return results;
    }

    @Override
    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dList setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return this.flag != null;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        if (this.flag != null) {
            return this.flag;
        }
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder dScriptArg = new StringBuilder();
        dScriptArg.append("li@");
        for (String item : this) {
            dScriptArg.append(item);
            dScriptArg.append('|');
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - 1);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public static void registerTags() {
        dList.registerTag("space_separated", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getAttribute(attribute.fulfill(1));
                }
                String input = " ";
                return new Element(dList.parseString((dList)object, input)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("as_string", registeredTags.get("space_separated"));
        dList.registerTag("asstring", registeredTags.get("space_separated"));
        dList.registerTag("separated_by", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                if (list.isEmpty()) {
                    return new Element("").getAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                return new Element(dList.parseString(list, input)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("comma_separated", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getAttribute(attribute.fulfill(1));
                }
                String input = ", ";
                return new Element(dList.parseString((dList)object, input)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("ascslist", registeredTags.get("comma_separated"));
        dList.registerTag("as_cslist", registeredTags.get("comma_separated"));
        dList.registerTag("unseparated", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getAttribute(attribute.fulfill(1));
                }
                String input = "";
                return new Element(dList.parseString((dList)object, input)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("get_sub_items", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int index = -1;
                if (aH.matchesInteger(attribute.getContext(1))) {
                    index = attribute.getIntContext(1) - 1;
                }
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                if (index < 0) {
                    return null;
                }
                dList sub_list = new dList();
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split));
                    if (strings.length > index) {
                        sub_list.add(strings[index]);
                        continue;
                    }
                    sub_list.add("null");
                }
                return sub_list.getAttribute(attribute);
            }
        });
        dList.registerTag("map_get", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(input)) continue;
                    return new Element(strings[1]).getAttribute(attribute);
                }
                return null;
            }
        });
        dList.registerTag("map_find_key", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                    return new Element(strings[0]).getAttribute(attribute);
                }
                return null;
            }
        });
        dList.registerTag("size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dList)object).size()).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("is_empty", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dList)object).isEmpty()).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("insert", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.insert[...] must have a value.");
                    return null;
                }
                dList items = dList.valueOf(attribute.getContext(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    dList result = new dList((dList)object);
                    int index = new Element(attribute.getContext(1)).asInt() - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size()) {
                        index = result.size();
                    }
                    for (int i = 0; i < items.size(); ++i) {
                        result.add(index + i, items.get(i));
                    }
                    return result.getAttribute(attribute.fulfill(1));
                }
                dB.echoError("The tag li@list.insert[...] must be followed by .at[#]!");
                return null;
            }
        });
        dList.registerTag("set", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.set[...] must have a value.");
                    return null;
                }
                if (((dList)object).isEmpty()) {
                    return null;
                }
                dList items = dList.valueOf(attribute.getContext(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    dList result = new dList((dList)object);
                    int index = new Element(attribute.getContext(1)).asInt() - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size() - 1) {
                        index = result.size() - 1;
                    }
                    result.remove(index);
                    for (int i = 0; i < items.size(); ++i) {
                        result.add(index + i, items.get(i));
                    }
                    return result.getAttribute(attribute.fulfill(1));
                }
                dB.echoError("The tag li@list.set[...] must be followed by .at[#]!");
                return null;
            }
        });
        dList.registerTag("include", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.include[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                list.addAll(dList.valueOf(attribute.getContext(1)));
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("exclude", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.exclude[...] must have a value.");
                    return null;
                }
                dList exclusions = dList.valueOf(attribute.getContext(1));
                dList list = new dList((dList)object);
                for (String exclusion : exclusions) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((String)list.get(i)).equalsIgnoreCase(exclusion)) continue;
                        list.remove(i--);
                    }
                }
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("remove", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.remove[#] must have a value.");
                    return null;
                }
                dList indices = dList.valueOf(attribute.getContext(1));
                dList list = new dList((dList)object);
                for (String index : indices) {
                    int remove = index.equalsIgnoreCase("last") ? list.size() - 1 : (index.equalsIgnoreCase("first") ? 0 : new Element(index).asInt() - 1);
                    if (remove < 0 || remove >= list.size()) continue;
                    list.set(remove, "\u0000");
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equals("\u0000")) continue;
                    list.remove(i--);
                }
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("replace", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.replace[...] must have a value.");
                    return null;
                }
                String replace = attribute.getContext(1);
                String replacement = "";
                attribute.fulfill(1);
                if (attribute.startsWith("with") && attribute.hasContext(1)) {
                    replacement = attribute.getContext(1);
                    if (replacement == null) {
                        replacement = "";
                    }
                    attribute.fulfill(1);
                }
                dList obj = (dList)object;
                dList list = new dList();
                if (replace.startsWith("regex:")) {
                    String regex = replace.substring("regex:".length());
                    for (String string : obj) {
                        if (string.matches(regex)) {
                            if (replacement.equals("")) continue;
                            list.add(replacement);
                            continue;
                        }
                        list.add(string);
                    }
                } else {
                    String lower = CoreUtilities.toLowerCase(replace);
                    for (String string : obj) {
                        if (CoreUtilities.toLowerCase(string).equals(lower)) {
                            if (replacement.equals("")) continue;
                            list.add(replacement);
                            continue;
                        }
                        list.add(string);
                    }
                }
                return list.getAttribute(attribute);
            }
        });
        dList.registerTag("reverse", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                Collections.reverse(list);
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("deduplicate", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList obj = (dList)object;
                dList list = new dList();
                int size = obj.size();
                for (int i = 0; i < size; ++i) {
                    String entry = (String)obj.get(i);
                    boolean duplicate = false;
                    for (int x = 0; x < i; ++x) {
                        if (!((String)obj.get(x)).equalsIgnoreCase(entry)) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                    list.add(entry);
                }
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("get", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.get[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                if (list.isEmpty()) {
                    return null;
                }
                dList indices = dList.valueOf(attribute.getContext(1));
                if (indices.size() > 1) {
                    dList results = new dList();
                    for (String index : indices) {
                        int ind = aH.getIntegerFrom(index);
                        if (ind <= 0 || ind > list.size()) continue;
                        results.add(list.get(ind - 1));
                    }
                    return results.getAttribute(attribute.fulfill(1));
                }
                if (indices.size() > 0) {
                    int index = aH.getIntegerFrom((String)indices.get(0));
                    if (index > list.size()) {
                        return null;
                    }
                    if (index < 1) {
                        index = 1;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("to") && attribute.hasContext(1)) {
                        int index2 = attribute.getIntContext(1);
                        if (index2 > list.size()) {
                            index2 = list.size();
                        }
                        if (index2 < 1) {
                            index2 = 1;
                        }
                        String item = "";
                        for (int i = index; i <= index2; ++i) {
                            item = item + (String)list.get(i - 1) + (i < index2 ? "|" : "");
                        }
                        return new dList(item).getAttribute(attribute.fulfill(1));
                    }
                    String item = (String)list.get(index - 1);
                    return ObjectFetcher.pickObjectFor(item).getAttribute(attribute);
                }
                return null;
            }
        });
        dList.registerTag("find_all_partial", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_all_partial[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                String test = attribute.getContext(1).toUpperCase();
                dList positions = new dList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find_all", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_all[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                dList positions = new dList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find_partial", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_partial[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                String test = attribute.getContext(1).toUpperCase();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    return new Element(i + 1).getAttribute(attribute.fulfill(1));
                }
                return new Element(-1).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    return new Element(i + 1).getAttribute(attribute.fulfill(1));
                }
                return new Element(-1).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("count", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.count[...] must have a value.");
                    return null;
                }
                dList list = new dList((dList)object);
                String element = attribute.getContext(1);
                int count = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(element)) continue;
                    ++count;
                }
                return new Element(count).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("first", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                if (list.isEmpty()) {
                    return null;
                }
                return new Element((String)list.get(0)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("last", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                if (list.isEmpty()) {
                    return null;
                }
                return new Element((String)list.get(list.size() - 1)).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("numerical", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                Collections.sort(list, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        double value = new Element(o1).asDouble() - new Element(o2).asDouble();
                        if (value == 0.0) {
                            return 0;
                        }
                        if (value > 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                });
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("alphanumeric", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                Collections.sort(list, new NaturalOrderComparator());
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("alphabetical", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList list = new dList((dList)object);
                Collections.sort(list, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("sort_by_number", new TagRunnable(){

            @Override
            public String run(final Attribute attribute, dObject object) {
                dList newlist = new dList((dList)object);
                try {
                    Collections.sort(newlist, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            double r2;
                            double r1 = new Element(ObjectFetcher.pickObjectFor(o1).getAttribute(new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context))).asDouble();
                            double value = r1 - (r2 = new Element(ObjectFetcher.pickObjectFor(o2).getAttribute(new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context))).asDouble());
                            if (value == 0.0) {
                                return 0;
                            }
                            if (value > 0.0) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    return newlist.getAttribute(attribute.fulfill(1));
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                    return newlist.getAttribute(attribute.fulfill(1));
                }
            }
        });
        dList.registerTag("sort", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList obj = new dList((dList)object);
                final ProcedureScriptContainer script = (ProcedureScriptContainer)dScript.valueOf(attribute.getContext(1)).getContainer();
                if (script == null) {
                    dB.echoError("'" + attribute.getContext(1) + "' is not a valid procedure script!");
                    return obj.getAttribute(attribute.fulfill(1));
                }
                final ScriptEntry entry = attribute.getScriptEntry();
                attribute = attribute.fulfill(1);
                dList context = new dList();
                if (attribute.startsWith("context")) {
                    context = dList.valueOf(attribute.getContext(1));
                    attribute = attribute.fulfill(1);
                }
                final dList context_send = context;
                ArrayList<String> list = new ArrayList<String>(obj);
                try {
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.getImplementation().getEmptyScriptEntryData() : entry.entryData.clone());
                            if (entries.isEmpty()) {
                                return 0;
                            }
                            long id = DetermineCommand.getNewId();
                            ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                            InstantQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId("DLIST_SORT"));
                            queue.addEntries(entries);
                            queue.setReqId(id);
                            int x = 1;
                            dList definitions = new dList();
                            definitions.add(o1);
                            definitions.add(o2);
                            definitions.addAll(context_send);
                            String[] definition_names = null;
                            try {
                                definition_names = script.getString("definitions").split("\\|");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            for (String definition : definitions) {
                                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                                queue.addDefinition(name, definition);
                                dB.echoDebug((Debuggable)entries.get(0), "Adding definition %" + name + "% as " + definition);
                                ++x;
                            }
                            queue.start();
                            int res = 0;
                            if (DetermineCommand.hasOutcome(id)) {
                                res = new Element(DetermineCommand.getOutcome(id).get(0)).asInt();
                            }
                            if (res < 0) {
                                return -1;
                            }
                            if (res > 0) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                }
                catch (Exception e) {
                    dB.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
                }
                return new dList((List<String>)list).getAttribute(attribute);
            }
        });
        dList.registerTag("filter", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList newlist = new dList();
                try {
                    for (String str : (dList)object) {
                        String result;
                        if (str == null) {
                            dB.echoError("Null string in dList! (From .filter tag)");
                        }
                        if ((result = ObjectFetcher.pickObjectFor(str).getAttribute(new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context))) == null || !result.equalsIgnoreCase("true")) continue;
                        newlist.add(str);
                    }
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                }
                return newlist.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("parse", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList newlist = new dList();
                try {
                    for (String str : (dList)object) {
                        String objs = ObjectFetcher.pickObjectFor(str).getAttribute(new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                        if (objs == null) {
                            objs = "null";
                        }
                        newlist.add(objs);
                    }
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                }
                return newlist.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("escape_contents", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList escaped = new dList();
                for (String entry : (dList)object) {
                    escaped.add(EscapeTags.Escape(entry));
                }
                return escaped.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("unescape_contents", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList escaped = new dList();
                for (String entry : (dList)object) {
                    escaped.add(EscapeTags.unEscape(entry));
                }
                return escaped.getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_any_case_sensitive", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_any_case_sensitive[...] must have a value.");
                    return null;
                }
                dList list = dList.valueOf(attribute.getContext(1));
                boolean state = false;
                block0: for (String element : (dList)object) {
                    for (String sub_element : list) {
                        if (!element.equals(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new Element(state).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_any", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_any[...] must have a value.");
                    return null;
                }
                dList list = dList.valueOf(attribute.getContext(1));
                boolean state = false;
                block0: for (String element : (dList)object) {
                    for (String sub_element : list) {
                        if (!element.equalsIgnoreCase(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new Element(state).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_case_sensitive", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_case_sensitive[...] must have a value.");
                    return null;
                }
                boolean state = false;
                for (String element : (dList)object) {
                    if (!element.equals(attribute.getContext(1))) continue;
                    state = true;
                    break;
                }
                return new Element(state).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains[...] must have a value.");
                    return null;
                }
                dList needed = dList.valueOf(attribute.getContext(1));
                int gotten = 0;
                block0: for (String check : needed) {
                    for (String element : (dList)object) {
                        if (!element.equalsIgnoreCase(check)) continue;
                        ++gotten;
                        continue block0;
                    }
                }
                return new Element(gotten == needed.size() && gotten > 0).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("List").getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("random", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList obj = (dList)object;
                if (obj.isEmpty()) {
                    return null;
                }
                if (attribute.hasContext(1)) {
                    int count = Integer.valueOf(attribute.getContext(1));
                    ArrayList<String> available = new ArrayList<String>();
                    available.addAll(obj);
                    dList toReturn = new dList();
                    for (int times = 0; !available.isEmpty() && times < count; ++times) {
                        int random = CoreUtilities.getRandom().nextInt(available.size());
                        toReturn.add(available.get(random));
                        available.remove(random);
                    }
                    return toReturn.getAttribute(attribute.fulfill(1));
                }
                return ObjectFetcher.pickObjectFor((String)obj.get(CoreUtilities.getRandom().nextInt(obj.size()))).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("closest_to", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.getClosestOption((dList)object, attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("prefix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dList)object).prefix).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("debug", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("identify", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.identify()).getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    private static String parseString(dList obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - spacer.length());
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        if (this.flag != null && (attribute.startsWith("as_list") || attribute.startsWith("aslist"))) {
            return new dList(this).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return this.flag != null ? new Element(DenizenCore.getImplementation().getLastEntryFromFlag(this.flag)).getAttribute(attribute) : new Element(this.identify()).getAttribute(attribute);
    }
}

