/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.Map;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.tags.TagManager;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void clickTrigger(NPCRightClickEvent event) {
        Map<String, String> idMap;
        if (!event.getNPC().hasTrait(TriggerTrait.class)) {
            return;
        }
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (!npc.getTriggerTrait().isEnabled(this.name)) {
            return;
        }
        dPlayer player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getClicker());
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, player);
        if (!trigger.wasTriggered()) {
            return;
        }
        if (trigger.hasDetermination() && trigger.getDetermination().equalsIgnoreCase("cancelled")) {
            event.setCancelled(true);
            return;
        }
        InteractScriptContainer script = npc.getInteractScript(player, this.getClass());
        String id = null;
        if (script != null && !(idMap = script.getIdMapFor(this.getClass(), player)).isEmpty()) {
            for (Map.Entry<String, String> entry : idMap.entrySet()) {
                String entry_value = TagManager.tag(entry.getValue(), new BukkitTagContext(player, npc, false, null, false, null));
                dItem item = dItem.valueOf(entry_value);
                if (item == null) {
                    dB.echoError("Invalid click trigger in script '" + script.getName() + "' (null trigger item)!");
                }
                if (item == null || item.comparesTo(player.getPlayerEntity().getItemInHand()) < 0 || !script.checkSpecificTriggerScriptRequirementsFor(this.getClass(), player, npc, entry.getKey())) continue;
                id = entry.getKey();
            }
        }
        if (!this.parse(npc, player, script, id)) {
            npc.action("no click trigger", player);
        }
    }

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }
}

