/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl.blocks;

import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_12_R1;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTagBuilder;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;

public class BlockData_v1_12_R1
implements BlockData {
    private Material material;
    private byte data;
    CompoundTag_v1_12_R1 ctag = null;

    public BlockData_v1_12_R1() {
    }

    public BlockData_v1_12_R1(short mat, byte dat) {
        this.material = Material.getMaterial((int)mat);
        this.data = dat;
    }

    public BlockData_v1_12_R1(Block block) {
        this.material = block.getType();
        this.data = block.getData();
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            this.ctag = (CompoundTag_v1_12_R1)CompoundTag_v1_12_R1.fromNMSTag(compound);
        }
    }

    public void setBlock(Block block) {
        block.setTypeIdAndData(this.material.getId(), this.data, false);
        if (this.ctag != null) {
            CompoundTagBuilder builder = this.ctag.createBuilder();
            builder.putInt("x", block.getX());
            builder.putInt("y", block.getY());
            builder.putInt("z", block.getZ());
            this.ctag = (CompoundTag_v1_12_R1)builder.build();
            BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
            TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
            te.load(this.ctag.toNMSTag());
        }
    }

    public String toCompressedFormat() {
        return "{" + this.material.getId() + ":" + this.data + "}";
    }

    public static BlockData fromCompressedString(String str) {
        BlockData_v1_12_R1 data = new BlockData_v1_12_R1();
        String inner = str.substring(1, str.length() - 1);
        String[] datas = inner.split(":");
        data.setMaterial(Material.getMaterial((int)Integer.parseInt(datas[0])));
        data.setData(Byte.parseByte(datas[1]));
        if (data.getMaterial() == null) {
            throw new RuntimeException("Null material: " + datas[0]);
        }
        return data;
    }

    public CompoundTag getCompoundTag() {
        return this.ctag;
    }

    public void setCompoundTag(CompoundTag tag) {
        this.ctag = (CompoundTag_v1_12_R1)tag;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public byte getData() {
        return this.data;
    }

    public void setData(byte data) {
        this.data = data;
    }
}

