/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.abstracts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class Sidebar {
    protected final Player player;
    protected String title;
    protected String[] lines;
    protected int[] scores;
    protected int start;
    protected int increment;

    public Sidebar(Player player) {
        this.player = player;
        this.setTitle("");
        this.lines = new String[15];
        this.scores = new int[15];
        this.start = Integer.MIN_VALUE;
        this.increment = -1;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getLines() {
        return new ArrayList<String>(Arrays.asList(this.lines));
    }

    public int[] getScores() {
        return this.scores;
    }

    public int getStart() {
        return this.start;
    }

    public int getIncrement() {
        return this.increment;
    }

    public final void setTitle(String title) {
        if (title.length() > 32) {
            title = title.substring(0, 32);
        }
        if (this.title == null || !this.title.equals(title)) {
            this.title = title;
            this.setDisplayName(title);
        }
    }

    protected abstract void setDisplayName(String var1);

    public void setStart(int start) {
        this.start = start;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public void setLines(List<String> lines) {
        lines.removeAll(Collections.singleton(null));
        this.lines = new String[15];
        this.scores = new int[15];
        int score = this.start;
        if (score == Integer.MIN_VALUE) {
            score = lines.size();
        }
        int i = 0;
        while (i < lines.size() && i < this.lines.length) {
            String line = lines.get(i);
            if (line.length() > 40) {
                line = line.substring(0, 40);
            }
            this.lines[i] = line;
            this.scores[i] = score;
            ++i;
            score += this.increment;
        }
    }

    public abstract void sendUpdate();

    public abstract void remove();
}

