/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.interfaces.ItemHelper;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && (((dItem)item).getItemStack().getType() == Material.POTION || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && (((dItem)item).getItemStack().getType() == Material.SPLASH_POTION || ((dItem)item).getItemStack().getType() == Material.LINGERING_POTION || ((dItem)item).getItemStack().getType() == Material.TIPPED_ARROW));
    }

    public static ItemPotion getFrom(dObject _item) {
        if (!ItemPotion.describes(_item)) {
            return null;
        }
        return new ItemPotion((dItem)_item);
    }

    private ItemPotion(dItem item) {
        this.item = item;
    }

    @Override
    public String getPropertyString() {
        if (!this.item.getItemStack().hasItemMeta()) {
            return null;
        }
        if (!(this.item.getItemStack().getItemMeta() instanceof PotionMeta)) {
            return null;
        }
        PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
        dList effects = new dList();
        effects.add(meta.getBasePotionData().getType() + "," + meta.getBasePotionData().isUpgraded() + "," + meta.getBasePotionData().isExtended() + (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && meta.hasColor() ? "," + new dColor(meta.getColor()).identify().replace(",", "&comma") : ""));
        for (PotionEffect pot : meta.getCustomEffects()) {
            StringBuilder sb = new StringBuilder();
            sb.append(pot.getType().getName()).append(",").append(pot.getAmplifier()).append(",").append(pot.getDuration()).append(",").append(pot.isAmbient()).append(",").append(pot.hasParticles());
            if (pot.getColor() != null) {
                sb.append(",").append(new dColor(pot.getColor()).identify().replace(",", "&comma"));
            }
            effects.add(sb.toString());
        }
        return effects.identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        boolean has;
        if (attribute == null) {
            return null;
        }
        boolean bl = has = this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof PotionMeta && ((PotionMeta)this.item.getItemStack().getItemMeta()).hasCustomEffects();
        if (attribute.startsWith("potion_base") && this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            return new Element(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getItemStack().getType() == Material.SPLASH_POTION) + (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && meta.hasColor() ? "," + new dColor(meta.getColor()).identify() : "")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_potion_effect")) {
            return new Element(has).getAttribute(attribute.fulfill(1));
        }
        if (has && attribute.startsWith("potion_effect")) {
            int potN;
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            int n = potN = attribute.hasContext(1) ? attribute.getIntContext(1) - 1 : 0;
            if (potN < 0 || potN > meta.getCustomEffects().size()) {
                return null;
            }
            if ((attribute = attribute.fulfill(1)).startsWith("is_splash")) {
                return new Element(this.item.getItemStack().getType() == Material.SPLASH_POTION).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new Element(meta.getBasePotionData().isExtended()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("level")) {
                return new Element(meta.getBasePotionData().isUpgraded() ? 2 : 1).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_ambient")) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).isAmbient()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("color")) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                    dB.echoError("Custom effects with the color option are not supported as of Minecraft version 1.13.");
                    return null;
                }
                if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2)) {
                    dB.echoError("Custom effects with the color option are not supported before Minecraft version 1.9.");
                    return null;
                }
                return new dColor(((PotionEffect)meta.getCustomEffects().get(potN)).getColor()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("icon") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).hasIcon()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("has_particles")) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).hasParticles()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("duration")) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).getDuration()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("amplifier")) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).getAmplifier()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("type")) {
                return new Element(((PotionEffect)meta.getCustomEffects().get(potN)).getType().getName()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("data")) {
                return new Element(0).getAttribute(attribute.fulfill(1));
            }
            return new Element(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getItemStack().getType() == Material.SPLASH_POTION)).getAttribute(attribute);
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String[] data;
        if (mechanism.matches("potion_effects")) {
            data = mechanism.getValue().asType(dList.class);
            String[] d1 = ((String)data.get(0)).split(",");
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            meta.setBasePotionData(new PotionData(PotionType.valueOf((String)d1[0].toUpperCase()), CoreUtilities.toLowerCase(d1[2]).equals("true"), CoreUtilities.toLowerCase(d1[1]).equals("true")));
            if (d1.length > 3) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
                    meta.setColor(dColor.valueOf(d1[3].replace("&comma", ",")).getColor());
                } else {
                    dB.echoError("Potion effect color is not supported before Minecraft version 1.11.");
                }
            }
            meta.clearCustomEffects();
            ItemHelper itemHelper = NMSHandler.getInstance().getItemHelper();
            for (int i = 1; i < data.size(); ++i) {
                String[] d2 = ((String)data.get(i)).split(",");
                PotionEffectType type = PotionEffectType.getByName((String)d2[0].toUpperCase());
                int duration = new Element(d2[2]).asInt();
                int amplifier = new Element(d2[1]).asInt();
                boolean ambient = new Element(d2[3]).asBoolean();
                boolean particles = new Element(d2[4]).asBoolean();
                Color color = null;
                boolean icon = false;
                if (d2.length > 5 && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2)) {
                    Object check;
                    if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                        check = new Element(d2[5]);
                        if (((Element)check).isBoolean()) {
                            icon = ((Element)check).asBoolean();
                        } else {
                            dB.echoError("Custom effects with the color option are not supported as of Minecraft version 1.13.");
                        }
                    } else {
                        check = d2[5].replace("&comma", ",");
                        if (dColor.matches((String)check)) {
                            color = dColor.valueOf((String)check).getColor();
                        }
                    }
                }
                meta.addCustomEffect(itemHelper.getPotionEffect(type, duration, amplifier, ambient, particles, color, icon), false);
            }
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("potion")) {
            data = mechanism.getValue().asString().split(",", 4);
            if (data.length < 4) {
                if (mechanism.getValue().isInt()) {
                    this.item.getItemStack().setDurability((short)mechanism.getValue().asInt());
                } else {
                    dB.echoError("Invalid effect format, use name,amplifier,extended,splash.");
                }
            } else {
                PotionType type;
                Element data1 = new Element(data[1]);
                Element data2 = new Element(data[2]);
                Element data3 = new Element(data[3]);
                try {
                    type = PotionType.valueOf((String)data[0].toUpperCase());
                }
                catch (Exception ex) {
                    dB.echoError("Invalid potion effect type '" + data[0] + "'");
                    return;
                }
                if (!data1.isInt()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[1] + "' is not a valid integer!");
                    return;
                }
                if (!data2.isBoolean()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[2] + "' is not a valid boolean!");
                    return;
                }
                if (!data3.isBoolean()) {
                    dB.echoError("Cannot apply effect '" + data[0] + "': '" + data[3] + "' is not a valid boolean!");
                    return;
                }
                Potion pot = new Potion(type);
                int d1 = data1.asInt();
                if (d1 >= 1 && d1 <= pot.getType().getMaxLevel()) {
                    pot.setLevel(d1);
                }
                if (!pot.getType().isInstant()) {
                    pot.setHasExtendedDuration(data2.asBoolean());
                }
                pot.setSplash(data3.asBoolean());
                this.item.setDurability((short)0);
                pot.apply(this.item.getItemStack());
            }
        }
    }
}

