/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class EventCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("context") && arg.matchesPrefix("context", "c")) {
                scriptEntry.addObject("context", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("events")) {
                scriptEntry.addObject("events", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("events")) {
            throw new InvalidArgumentsException("Must specify a list of event names!");
        }
        scriptEntry.defaultObject("context", new dList());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dList events = (dList)scriptEntry.getObject("events");
        dList context = (dList)scriptEntry.getObject("context");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), events.debug() + context.debug());
        }
        if (context.size() % 2 == 1) {
            context.add("null");
        }
        HashMap<String, dObject> context_map = new HashMap<String, dObject>();
        for (int i = 0; i < context.size(); i += 2) {
            context_map.put((String)context.get(i), ObjectFetcher.pickObjectFor((String)context.get(i + 1)));
        }
        List<String> Determination = OldEventManager.doEvents(events, scriptEntry.entryData, context_map, true);
        scriptEntry.addObject("determinations", new dList(Determination));
    }
}

