/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.server;

import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class AnnounceCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException("Too many arguments! Did you forget a 'quote'?");
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matches("to_ops")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_OPS);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("to_console")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_CONSOLE);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("to_flagged")) {
                scriptEntry.addObject("type", (Object)AnnounceType.TO_FLAGGED);
                scriptEntry.addObject("flag", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format")) {
                FormatScriptContainer format = null;
                String formatStr = arg.getValue();
                format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(formatStr);
                if (format == null) {
                    dB.echoError("Could not find format script matching '" + formatStr + '\'');
                }
                scriptEntry.addObject("format", format);
                continue;
            }
            if (scriptEntry.hasObject("text")) continue;
            scriptEntry.addObject("text", new Element(arg.raw_value));
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Missing text argument!");
        }
        scriptEntry.defaultObject("type", new Object[]{AnnounceType.ALL});
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String message;
        Element text = scriptEntry.getElement("text");
        AnnounceType type = (AnnounceType)((Object)scriptEntry.getObject("type"));
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        Element flag = scriptEntry.getElement("flag");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("Message", text) + (format != null ? aH.debugObj("Format", format.getName()) : "") + aH.debugObj("Type", type.name()) + (flag != null ? aH.debugObj("Flag_Name", flag) : ""));
        }
        String string = message = format != null ? format.getFormattedText(scriptEntry) : text.asString();
        if (type == AnnounceType.ALL) {
            DenizenAPI.getCurrentInstance().getServer().broadcastMessage(message);
        } else if (type == AnnounceType.TO_OPS) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(message);
            }
        } else if (type == AnnounceType.TO_FLAGGED) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!FlagManager.playerHasFlag(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player), flag.asString())) continue;
                player.sendMessage(message);
            }
        } else if (type == AnnounceType.TO_CONSOLE) {
            Bukkit.getServer().getConsoleSender().sendMessage(message);
        }
    }

    static enum AnnounceType {
        ALL,
        TO_OPS,
        TO_FLAGGED,
        TO_CONSOLE;

    }
}

