/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.interfaces.dRegistry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.core.AsyncCommand;
import net.aufdemrand.denizencore.scripts.commands.core.ChooseCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DebugCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DefineCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.commands.core.ElseCommand;
import net.aufdemrand.denizencore.scripts.commands.core.ForeachCommand;
import net.aufdemrand.denizencore.scripts.commands.core.GotoCommand;
import net.aufdemrand.denizencore.scripts.commands.core.IfCommand;
import net.aufdemrand.denizencore.scripts.commands.core.MarkCommand;
import net.aufdemrand.denizencore.scripts.commands.core.SyncCommand;
import net.aufdemrand.denizencore.scripts.commands.core.WebGetCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public abstract class CommandRegistry
implements dRegistry {
    public final Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    public final Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    @Override
    public boolean register(String commandName, RegistrationableInstance commandInstance) {
        this.instances.put(CoreUtilities.toLowerCase(commandName), (AbstractCommand)commandInstance);
        this.classes.put(((AbstractCommand)commandInstance).getClass(), CoreUtilities.toLowerCase(commandName));
        return true;
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    @Override
    public AbstractCommand get(String commandName) {
        return this.instances.get(CoreUtilities.toLowerCase(commandName));
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        String command = this.classes.get(clazz);
        if (command != null) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(command)));
        }
        return null;
    }

    public void registerCoreCommands() {
        this.registerCoreMember(AsyncCommand.class, "async", "async [<commands>]", 0);
        this.registerCoreMember(ChooseCommand.class, "choose", "choose [<option>] [<cases>]", 1);
        this.registerCoreMember(DebugCommand.class, "debug", "debug [<type>] [<message>] (name:<name>)", 2);
        this.registerCoreMember(DefineCommand.class, "define", "define [<id>] [<value>]", 1);
        this.registerCoreMember(DetermineCommand.class, "determine", "determine (passively) [<value>]", 1);
        this.registerCoreMember(ElseCommand.class, "ELSE", "else (if <comparison logic>)", 0);
        this.registerCoreMember(ForeachCommand.class, "foreach", "foreach [stop/next/<object>|...] [<commands>]", 1);
        this.registerCoreMember(GotoCommand.class, "GOTO", "goto [<name>]", 1);
        this.registerCoreMember(IfCommand.class, "IF", "if [<value>] (!)(<operator> <value>) (&&/|| ...) [<commands>] (else <commands>)", 1);
        this.registerCoreMember(MarkCommand.class, "MARK", "mark [<name>]", 1);
        this.registerCoreMember(SyncCommand.class, "sync", "sync [<commands>]", 0);
        this.registerCoreMember(WebGetCommand.class, "webget", "webget [<url>] (post:<data>) (headers:<header>/<value>|...) (timeout:<duration>/{10s})", 1);
    }

    public <T extends AbstractCommand> void registerCoreMember(Class<T> cmd, String names, String hint, int args) {
        for (String name : names.split(", ")) {
            try {
                ((AbstractCommand)cmd.newInstance()).activate().as(name).withOptions(hint, args);
            }
            catch (Throwable e) {
                dB.echoError("Could not register command " + name + ": " + e.getMessage());
                dB.echoError(e);
            }
        }
    }

    @Override
    public void disableCoreMembers() {
        for (RegistrationableInstance registrationableInstance : this.instances.values()) {
            try {
                registrationableInstance.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + registrationableInstance.getClass().getName() + "'!");
                dB.echoError(e);
            }
        }
    }
}

