/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms;

import java.util.Map;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.AnimationHelper;
import net.aufdemrand.denizen.nms.abstracts.BiomeNMS;
import net.aufdemrand.denizen.nms.abstracts.BlockLight;
import net.aufdemrand.denizen.nms.abstracts.ParticleHelper;
import net.aufdemrand.denizen.nms.abstracts.ProfileEditor;
import net.aufdemrand.denizen.nms.abstracts.Sidebar;
import net.aufdemrand.denizen.nms.interfaces.AdvancementHelper;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.nms.interfaces.ChunkHelper;
import net.aufdemrand.denizen.nms.interfaces.CustomEntityHelper;
import net.aufdemrand.denizen.nms.interfaces.EntityHelper;
import net.aufdemrand.denizen.nms.interfaces.FishingHelper;
import net.aufdemrand.denizen.nms.interfaces.ItemHelper;
import net.aufdemrand.denizen.nms.interfaces.PacketHelper;
import net.aufdemrand.denizen.nms.interfaces.PlayerHelper;
import net.aufdemrand.denizen.nms.interfaces.SoundHelper;
import net.aufdemrand.denizen.nms.interfaces.WorldHelper;
import net.aufdemrand.denizen.nms.interfaces.packets.PacketHandler;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.Tag;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public abstract class NMSHandler {
    private static NMSHandler instance;
    private static NMSVersion version;
    private static JavaPlugin javaPlugin;

    public static boolean initialize(JavaPlugin plugin) {
        javaPlugin = plugin;
        String packageName = javaPlugin.getServer().getClass().getPackage().getName();
        try {
            version = NMSVersion.valueOf(packageName.substring(packageName.lastIndexOf(46) + 1));
        }
        catch (Exception e) {
            version = NMSVersion.NOT_SUPPORTED;
            instance = null;
            return false;
        }
        try {
            Class<?> clazz = Class.forName("net.aufdemrand.denizen.nms.Handler_" + version.name());
            if (NMSHandler.class.isAssignableFrom(clazz)) {
                instance = (NMSHandler)clazz.newInstance();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        version = NMSVersion.NOT_SUPPORTED;
        instance = null;
        return false;
    }

    public static NMSHandler getInstance() {
        return instance;
    }

    public static NMSVersion getVersion() {
        return version;
    }

    public static JavaPlugin getJavaPlugin() {
        return javaPlugin;
    }

    public boolean isCorrectMappingsCode() {
        return true;
    }

    public abstract void disableAsyncCatcher();

    public abstract Sidebar createSidebar(Player var1);

    public abstract BlockLight createBlockLight(Location var1, int var2, long var3);

    public abstract PlayerProfile fillPlayerProfile(PlayerProfile var1);

    public abstract PlayerProfile getPlayerProfile(Player var1);

    public abstract ProfileEditor getProfileEditor();

    public abstract BiomeNMS getBiomeNMS(Biome var1);

    public abstract Thread getMainThread();

    public abstract double[] getRecentTps();

    public abstract AdvancementHelper getAdvancementHelper();

    public abstract AnimationHelper getAnimationHelper();

    public abstract BlockHelper getBlockHelper();

    public abstract ChunkHelper getChunkHelper();

    public abstract CustomEntityHelper getCustomEntityHelper();

    public abstract EntityHelper getEntityHelper();

    public abstract FishingHelper getFishingHelper();

    public abstract ItemHelper getItemHelper();

    public abstract SoundHelper getSoundHelper();

    public abstract PacketHelper getPacketHelper();

    public abstract ParticleHelper getParticleHelper();

    public abstract PlayerHelper getPlayerHelper();

    public abstract WorldHelper getWorldHelper();

    public abstract void enablePacketInterception(PacketHandler var1);

    public abstract CompoundTag createCompoundTag(Map<String, Tag> var1);

    public abstract int getPort();

    public static Vector fixOffset(Vector offset, double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        Vector offsetPatched = offset.clone();
        double cosPitch = Math.cos(pitch);
        double sinPitch = Math.sin(pitch);
        double y1 = offsetPatched.getY() * cosPitch - offsetPatched.getZ() * sinPitch;
        double z1 = offsetPatched.getY() * sinPitch + offsetPatched.getZ() * cosPitch;
        offsetPatched.setY(y1);
        offsetPatched.setZ(z1);
        double cosYaw = Math.cos(yaw);
        double sinYaw = Math.sin(yaw);
        double x2 = offsetPatched.getX() * cosYaw + offsetPatched.getZ() * sinYaw;
        double z2 = offsetPatched.getX() * -sinYaw + offsetPatched.getZ() * cosYaw;
        offsetPatched.setX(x2);
        offsetPatched.setZ(z2);
        return offsetPatched;
    }

    public void forceAttachMove(Entity a, Entity b, Vector offset, boolean matchRotation) {
        throw new RuntimeException("Unsupported forceAttachMove!");
    }

    public Boolean getSwitchState(Block b) {
        return null;
    }

    public boolean setSwitchState(Location interactLocation, boolean state) {
        return false;
    }
}

