/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import sun.misc.Unsafe;

public class DenizenAtomicIntegerFieldUpdater<T>
extends AtomicIntegerFieldUpdater<T> {
    private static final Unsafe unsafe;
    private final long offset;

    public DenizenAtomicIntegerFieldUpdater(Field field) {
        field.setAccessible(true);
        int modifiers = field.getModifiers();
        Class<?> fieldt = field.getType();
        if (fieldt != Integer.TYPE) {
            throw new IllegalArgumentException("Must be integer type");
        }
        if (!Modifier.isVolatile(modifiers)) {
            throw new IllegalArgumentException("Must be volatile type");
        }
        this.offset = unsafe.objectFieldOffset(field);
    }

    @Override
    public boolean compareAndSet(T obj, int expect, int update) {
        return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
    }

    @Override
    public boolean weakCompareAndSet(T obj, int expect, int update) {
        return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
    }

    @Override
    public void set(T obj, int newValue) {
        unsafe.putIntVolatile(obj, this.offset, newValue);
    }

    @Override
    public void lazySet(T obj, int newValue) {
        unsafe.putOrderedInt(obj, this.offset, newValue);
    }

    @Override
    public final int get(T obj) {
        return unsafe.getIntVolatile(obj, this.offset);
    }

    static {
        Unsafe theUnsafe = null;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            theUnsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        unsafe = theUnsafe;
    }
}

