/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;

public class EntityShootsBowEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityShootsBowEvent instance;
    public dEntity entity;
    public Float force;
    public dItem bow;
    public dEntity projectile;
    public EntityShootBowEvent event;

    public EntityShootsBowEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("shoots");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        String attacker = CoreUtilities.getXthArg(0, lower);
        String item = CoreUtilities.getXthArg(2, lower);
        if (!this.tryEntity(this.entity, attacker)) {
            return false;
        }
        if (!item.equals("bow") && !this.tryItem(this.bow, item)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityShootsBow";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.Argument.valueOf(determination).matchesArgumentList(dEntity.class)) {
            this.cancelled = true;
            List<dEntity> newProjectiles = dList.valueOf(determination).filter(dEntity.class, container);
            for (dEntity newProjectile : newProjectiles) {
                newProjectile.spawnAt(this.entity.getEyeLocation().add(this.entity.getEyeLocation().getDirection()));
                if (!newProjectile.isProjectile()) continue;
                newProjectile.setShooter(this.entity);
            }
            Position.mount(Conversion.convertEntities(newProjectiles));
            Entity lastProjectile = newProjectiles.get(newProjectiles.size() - 1).getBukkitEntity();
            lastProjectile.setVelocity(this.event.getEntity().getLocation().getDirection().multiply(this.force.floatValue()));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("force")) {
            return new Element(this.force.floatValue());
        }
        if (name.equals("bow")) {
            return this.bow;
        }
        if (name.equals("projectile")) {
            return this.projectile;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityShootsBow(EntityShootBowEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.force = Float.valueOf(event.getForce() * 3.0f);
        this.bow = new dItem(event.getBow());
        Entity projectileEntity = event.getProjectile();
        dEntity.rememberEntity(projectileEntity);
        this.projectile = new dEntity(projectileEntity);
        this.event = event;
        this.fire((Cancellable)event);
        dEntity.forgetEntity(projectileEntity);
    }
}

