/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SlimeSplitEvent;

public class SlimeSplitsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SlimeSplitsScriptEvent instance;
    public dEntity entity;
    public int count;
    public SlimeSplitEvent event;

    public SlimeSplitsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("slime splits");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        String counts = CoreUtilities.getXthArg(3, lower);
        if (CoreUtilities.xthArgEquals(2, lower, "into") && !counts.isEmpty()) {
            try {
                if (Integer.parseInt(counts) != this.count) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "SlimeSplits";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesInteger(determination)) {
            this.count = aH.getIntegerFrom(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("count")) {
            return new Element(this.count);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSlimeSplits(SlimeSplitEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.count = event.getCount();
        this.event = event;
        this.fire((Cancellable)event);
        event.setCount(this.count);
    }
}

