/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class PlayerBreaksBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerBreaksBlockScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public dList cuboids;
    public Element xp;
    public BlockBreakEvent event;

    public PlayerBreaksBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player breaks");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        String mat = CoreUtilities.getXthArg(2, lower);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.runWithCheck(path, new dItem(this.event.getPlayer().getItemInHand()))) {
            return false;
        }
        return !CoreUtilities.xthArgEquals(3, lower, "with") || this.tryItem(new dItem(this.event.getPlayer().getItemInHand()), CoreUtilities.getXthArg(4, lower));
    }

    @Override
    public String getName() {
        return "PlayerBreaksBlock";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        Block block = this.event.getBlock();
        if (lower.equals("nothing")) {
            this.cancelled = true;
            block.setType(Material.AIR);
        } else if (aH.matchesInteger(determination)) {
            this.xp = aH.Argument.valueOf(lower).asElement();
        } else if (aH.Argument.valueOf(lower).matchesArgumentList(dItem.class)) {
            this.cancelled = true;
            block.setType(Material.AIR);
            for (dItem newItem : dList.valueOf(determination).filter(dItem.class, container)) {
                block.getWorld().dropItemNaturally(block.getLocation(), newItem.getItemStack());
            }
        } else {
            return super.applyDetermination(container, determination);
        }
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("cuboids")) {
            if (this.cuboids == null) {
                this.cuboids = new dList();
                for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                    this.cuboids.add(cuboid.identifySimple());
                }
            }
            return this.cuboids;
        }
        if (name.equals("xp")) {
            return this.xp;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerBreaksBlock(BlockBreakEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = new dMaterial(event.getBlock());
        this.location = new dLocation(event.getBlock().getLocation());
        this.cuboids = null;
        this.xp = new Element(event.getExpToDrop());
        this.event = event;
        this.fire((Cancellable)event);
        event.setExpToDrop(this.xp.asInt());
    }
}

