/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLevelChangeEvent;

public class PlayerLevelsUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLevelsUpScriptEvent instance;
    public int new_level;
    public int old_level;
    public dPlayer player;
    public PlayerLevelChangeEvent event;

    public PlayerLevelsUpScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player levels up");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 0; index < data.size(); ++index) {
            if (data.get(index).equals("from") && aH.getIntegerFrom(data.get(index + 1)) != this.old_level) {
                return false;
            }
            if (!data.get(index).equals("to") || aH.getIntegerFrom(data.get(index + 1)) == this.new_level) continue;
            return false;
        }
        return this.runInCheck(path, this.player.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerLevelsUp";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("level") || name.equals("new_level")) {
            return new Element(this.new_level);
        }
        if (name.equals("old_level")) {
            return new Element(this.old_level);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLevels(PlayerLevelChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.old_level = event.getOldLevel();
        this.new_level = event.getNewLevel();
        this.event = event;
        this.fire();
    }
}

