/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerWalkScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerWalkScriptEvent instance;
    public dLocation old_location;
    public dLocation new_location;
    public PlayerMoveEvent event;

    public PlayerWalkScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player walks") && !CoreUtilities.xthArgEquals(2, lower, "over");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        return this.runInCheck(path, this.old_location) || this.runInCheck(path, this.new_location);
    }

    @Override
    public String getName() {
        return "PlayerWalks";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("old_location")) {
            return this.old_location;
        }
        if (name.equals("new_location")) {
            return this.new_location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerMoves(PlayerMoveEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.old_location = new dLocation(event.getFrom());
        this.new_location = new dLocation(event.getTo());
        this.event = event;
        this.fire((Cancellable)event);
    }
}

